/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.impl;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.enums.EnumDB;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.enums.EnumSyncAction;
import org.pinus4j.cache.ICacheBuilder;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cache.impl.MemCachedCacheBuilder;
import org.pinus4j.cluster.DefaultContainerFactory;
import org.pinus4j.cluster.IContainer;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.ITableCluster;
import org.pinus4j.cluster.ITableClusterBuilder;
import org.pinus4j.cluster.beans.DBClusterInfo;
import org.pinus4j.cluster.beans.DBClusterRegionInfo;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.config.IClusterConfig;
import org.pinus4j.cluster.config.impl.XmlClusterConfigImpl;
import org.pinus4j.cluster.impl.NumberIndexTableClusterBuilder;
import org.pinus4j.cluster.resources.DBResourceCache;
import org.pinus4j.cluster.resources.GlobalDBResource;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.cluster.router.IClusterRouter;
import org.pinus4j.cluster.router.IClusterRouterBuilder;
import org.pinus4j.cluster.router.RouteInfo;
import org.pinus4j.cluster.router.impl.DefaultClusterRouterBuilder;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.jdbc.JdbcDataLayerBuilder;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.exceptions.DBRouteException;
import org.pinus4j.exceptions.LoadConfigException;
import org.pinus4j.generator.DefaultDBGeneratorBuilder;
import org.pinus4j.generator.IDBGenerator;
import org.pinus4j.generator.IDBGeneratorBuilder;
import org.pinus4j.generator.IIdGenerator;
import org.pinus4j.generator.beans.DBTable;
import org.pinus4j.generator.impl.DistributedSequenceIdGeneratorImpl;
import org.pinus4j.transaction.impl.BestEffortsOnePCJtaTransactionManager;
import org.pinus4j.utils.CuratorDistributeedLock;
import org.pinus4j.utils.IOUtil;
import org.pinus4j.utils.ReflectUtil;
import org.pinus4j.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBCluster
implements IDBCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDBCluster.class);
    private EnumSyncAction syncAction = EnumSyncAction.CREATE;
    private String scanPackage;
    private boolean isShardInfoFromZk;
    protected EnumDB enumDb = EnumDB.MYSQL;
    private IDBGenerator dbGenerator;
    private IIdGenerator idGenerator;
    private IPrimaryCache primaryCache;
    private ISecondCache secondCache;
    private TransactionManager txManager;
    private IContainer<IClusterRouter> dbRouterC;
    private IContainer<DBClusterInfo> dbClusterInfoC;
    private ITableCluster tableCluster;
    private IClusterConfig config;
    private CuratorFramework curatorClient;

    public AbstractDBCluster(EnumDB enumDb) {
        this.enumDb = enumDb;
    }

    @Override
    public Collection<DBClusterInfo> getDBClusterInfo() {
        return this.dbClusterInfoC.values();
    }

    @Override
    public DBClusterInfo getDBClusterInfo(String clusterName) {
        DBClusterInfo clusterInfo = this.dbClusterInfoC.find(clusterName);
        if (clusterInfo == null) {
            throw new DBOperationException("\u627e\u4e0d\u5230\u96c6\u7fa4\u4fe1\u606f, clusterName=" + clusterName);
        }
        return clusterInfo;
    }

    @Override
    public void startup() throws DBClusterException {
        this.startup(null);
    }

    @Override
    public void startup(String xmlFilePath) throws DBClusterException {
        LOG.info("start init database cluster");
        try {
            this.config = this._getConfig(xmlFilePath);
        }
        catch (LoadConfigException e) {
            throw new RuntimeException(e);
        }
        this.curatorClient = CuratorFrameworkFactory.newClient((String)this.config.getZookeeperUrl(), (RetryPolicy)new RetryNTimes(5, 1000));
        this.curatorClient.start();
        try {
            ZooKeeper zkClient = this.curatorClient.getZookeeperClient().getZooKeeper();
            Stat stat = zkClient.exists("/pinus", false);
            if (stat == null) {
                zkClient.create("/pinus", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("\u521d\u59cb\u5316zookeeper\u6839\u76ee\u5f55\u5931\u8d25");
        }
        this.idGenerator = new DistributedSequenceIdGeneratorImpl(this.config, this.curatorClient);
        LOG.info("init primary key generator done");
        ICacheBuilder cacheBuilder = MemCachedCacheBuilder.valueOf(this.config);
        this.primaryCache = cacheBuilder.buildPrimaryCache();
        this.secondCache = cacheBuilder.buildSecondCache();
        this.txManager = BestEffortsOnePCJtaTransactionManager.getInstance();
        IDBGeneratorBuilder dbGeneratorBuilder = DefaultDBGeneratorBuilder.valueOf(this.syncAction, this.enumDb);
        this.dbGenerator = dbGeneratorBuilder.build();
        Collection<DBClusterInfo> dbClusterInfos = this.config.getDBClusterInfos();
        try {
            this._initDBCluster(dbClusterInfos);
            List<DBTable> tables = null;
            if (this.isShardInfoFromZk) {
                tables = this.getDBTableFromZk();
            } else {
                if (StringUtils.isBlank(this.scanPackage)) {
                    throw new DBClusterException("get shardinfo from jvm, but i can't find scanpackage full path, did you forget setScanPackage ?");
                }
                tables = this.getDBTableFromJvm();
                this._syncToZookeeper(tables);
            }
            if (tables.isEmpty()) {
                throw new DBClusterException("\u627e\u4e0d\u5230\u53ef\u4ee5\u521b\u5efa\u5e93\u8868\u7684\u5b9e\u4f53\u5bf9\u8c61, package=" + this.scanPackage);
            }
            ITableClusterBuilder tableClusterBuilder = NumberIndexTableClusterBuilder.valueOf(tables);
            this.tableCluster = tableClusterBuilder.build();
            if (this.syncAction != EnumSyncAction.NONE) {
                LOG.info("syncing table info");
                long start = System.currentTimeMillis();
                this._createTable(tables);
                LOG.info("sync table info done, const time:" + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (Exception e) {
            throw new DBClusterException("init database cluster failure", e);
        }
        this.dbRouterC = DefaultContainerFactory.createContainer(DefaultContainerFactory.ContainerType.MAP);
        IClusterRouterBuilder routerBuilder = null;
        String clusterName = null;
        for (DBClusterInfo clusterInfo : this.dbClusterInfoC.values()) {
            clusterName = clusterInfo.getClusterName();
            routerBuilder = DefaultClusterRouterBuilder.valueOf(this);
            routerBuilder.setHashAlgo(this.config.getHashAlgo());
            this.dbRouterC.add(clusterName, routerBuilder.build(clusterName));
        }
        LOG.info("init database cluster done.");
    }

    @Override
    public void shutdown() throws DBClusterException {
        if (this.primaryCache != null) {
            this.primaryCache.close();
        }
        if (this.secondCache != null) {
            this.secondCache.close();
        }
        try {
            for (DBClusterInfo dbClusterInfo : this.dbClusterInfoC.values()) {
                List<DBInfo> slaveDbs;
                DBInfo masterGlobal = dbClusterInfo.getMasterGlobalDBInfo();
                if (masterGlobal != null) {
                    this.closeDataSource(masterGlobal);
                }
                if ((slaveDbs = dbClusterInfo.getSlaveGlobalDBInfo()) != null && !slaveDbs.isEmpty()) {
                    for (DBInfo slaveGlobal : slaveDbs) {
                        this.closeDataSource(slaveGlobal);
                    }
                }
                for (DBClusterRegionInfo regionInfo : dbClusterInfo.getDbRegions()) {
                    for (DBInfo dBInfo : regionInfo.getMasterDBInfos()) {
                        this.closeDataSource(dBInfo);
                    }
                    for (List list : regionInfo.getSlaveDBInfos()) {
                        for (DBInfo dbConnInfo : list) {
                            this.closeDataSource(dbConnInfo);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DBClusterException("\u5173\u95ed\u6570\u636e\u5e93\u96c6\u7fa4\u5931\u8d25", e);
        }
        DBResourceCache.clear();
        CloseableUtils.closeQuietly((Closeable)this.curatorClient);
    }

    @Override
    public IDBResource getMasterGlobalDBResource(String clusterName, String tableName) throws DBClusterException {
        IDBResource masterDBResource;
        DBClusterInfo dbClusterInfo = this.dbClusterInfoC.find(clusterName);
        if (dbClusterInfo == null) {
            throw new DBClusterException("\u6ca1\u6709\u627e\u5230\u96c6\u7fa4\u4fe1\u606f, clustername=" + clusterName);
        }
        DBInfo masterDBInfo = dbClusterInfo.getMasterGlobalDBInfo();
        if (masterDBInfo == null) {
            throw new DBClusterException("\u6b64\u96c6\u7fa4\u6ca1\u6709\u914d\u7f6e\u5168\u5c40\u4e3b\u5e93, clustername=" + clusterName);
        }
        try {
            masterDBResource = GlobalDBResource.valueOf(masterDBInfo, tableName);
        }
        catch (SQLException e) {
            throw new DBClusterException(e);
        }
        return masterDBResource;
    }

    @Override
    public IDBResource getSlaveGlobalDBResource(String clusterName, String tableName, EnumDBMasterSlave slave) throws DBClusterException {
        IDBResource slaveDBResource;
        DBClusterInfo dbClusterInfo = this.dbClusterInfoC.find(clusterName);
        if (dbClusterInfo == null) {
            throw new DBClusterException("\u6ca1\u6709\u627e\u5230\u96c6\u7fa4\u4fe1\u606f, clustername=" + clusterName);
        }
        List<DBInfo> slaveDbs = dbClusterInfo.getSlaveGlobalDBInfo();
        if (slaveDbs == null || slaveDbs.isEmpty()) {
            throw new DBClusterException("\u6b64\u96c6\u7fa4\u6ca1\u6709\u914d\u7f6e\u5168\u5c40\u4ece\u5e93, clustername=" + clusterName);
        }
        DBInfo slaveDBInfo = slaveDbs.get(slave.getValue());
        try {
            slaveDBResource = GlobalDBResource.valueOf(slaveDBInfo, tableName);
        }
        catch (SQLException e) {
            throw new DBClusterException(e);
        }
        return slaveDBResource;
    }

    @Override
    public ShardingDBResource selectDBResourceFromMaster(String tableName, IShardingKey<?> value) throws DBClusterException {
        ShardingDBResource db;
        String clusterName;
        RouteInfo routeInfo = null;
        try {
            clusterName = value.getClusterName();
            IClusterRouter router = this.dbRouterC.find(clusterName);
            if (router == null) {
                throw new IllegalStateException("can not found db router by " + clusterName);
            }
            routeInfo = router.select(EnumDBMasterSlave.MASTER, tableName, value);
        }
        catch (DBRouteException e) {
            throw new DBClusterException(e);
        }
        clusterName = routeInfo.getClusterName();
        DBInfo dbInfo = routeInfo.getDbInfo();
        int tableIndex = routeInfo.getTableIndex();
        DBClusterInfo dbClusterInfo = this.dbClusterInfoC.find(clusterName);
        if (dbClusterInfo == null) {
            throw new DBClusterException("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u96c6\u7fa4, shardingkey=" + value + ", tablename=" + tableName);
        }
        DBClusterRegionInfo regionInfo = dbClusterInfo.getDbRegions().get(routeInfo.getRegionIndex());
        if (regionInfo == null) {
            throw new DBClusterException("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u96c6\u7fa4, shardingkey=" + value + ", tablename=" + tableName);
        }
        try {
            db = ShardingDBResource.valueOf(dbInfo, regionInfo, tableName, tableIndex);
        }
        catch (SQLException e) {
            throw new DBClusterException(e);
        }
        return db;
    }

    @Override
    public ShardingDBResource selectDBResourceFromSlave(String tableName, IShardingKey<?> value, EnumDBMasterSlave slaveNum) throws DBClusterException {
        ShardingDBResource db;
        String clusterName;
        RouteInfo routeInfo = null;
        try {
            clusterName = value.getClusterName();
            IClusterRouter router = this.dbRouterC.find(clusterName);
            if (router == null) {
                throw new IllegalStateException("can not found db router by " + clusterName);
            }
            routeInfo = router.select(slaveNum, tableName, value);
        }
        catch (DBRouteException e) {
            throw new DBClusterException(e);
        }
        clusterName = routeInfo.getClusterName();
        DBInfo dbInfo = routeInfo.getDbInfo();
        int tableIndex = routeInfo.getTableIndex();
        DBClusterInfo dbClusterInfo = this.dbClusterInfoC.find(clusterName);
        if (dbClusterInfo == null) {
            throw new DBClusterException("can not found db cluster by " + clusterName + ", shardingkey is " + value + ", tablename is " + tableName + ", slavenum is " + slaveNum.getValue());
        }
        DBClusterRegionInfo regionInfo = dbClusterInfo.getDbRegions().get(routeInfo.getRegionIndex());
        if (regionInfo == null) {
            throw new DBClusterException("can not found db cluster by " + clusterName + "shardingkey is " + value + ", tablename is " + tableName + ", slavenum is " + slaveNum.getValue());
        }
        try {
            db = ShardingDBResource.valueOf(dbInfo, regionInfo, tableName, tableIndex);
        }
        catch (SQLException e) {
            throw new DBClusterException(e);
        }
        return db;
    }

    @Override
    public List<IDBResource> getAllMasterShardingDBResource(Class<?> clazz) throws SQLException {
        int tableNum = ReflectUtil.getTableNum(clazz);
        if (tableNum == 0) {
            throw new IllegalStateException("table number is 0");
        }
        String clusterName = ReflectUtil.getClusterName(clazz);
        String tableName = ReflectUtil.getTableName(clazz);
        return this.getAllMasterShardingDBResource(tableNum, clusterName, tableName);
    }

    @Override
    public List<IDBResource> getAllMasterShardingDBResource(int tableNum, String clusterName, String tableName) throws SQLException {
        ArrayList<IDBResource> dbResources = new ArrayList<IDBResource>();
        if (tableNum == 0) {
            throw new IllegalStateException("table number is 0");
        }
        ShardingDBResource dbResource = null;
        DBClusterInfo dbClusterInfo = this.getDBClusterInfo(clusterName);
        for (DBClusterRegionInfo region : dbClusterInfo.getDbRegions()) {
            for (DBInfo dbInfo : region.getMasterDBInfos()) {
                for (int tableIndex = 0; tableIndex < tableNum; ++tableIndex) {
                    dbResource = ShardingDBResource.valueOf(dbInfo, region, tableName, tableIndex);
                    dbResources.add(dbResource);
                }
            }
        }
        return dbResources;
    }

    @Override
    public List<IDBResource> getAllSlaveShardingDBResource(Class<?> clazz, EnumDBMasterSlave slave) throws SQLException {
        ArrayList<IDBResource> dbResources = new ArrayList<IDBResource>();
        int tableNum = ReflectUtil.getTableNum(clazz);
        if (tableNum == 0) {
            throw new IllegalStateException("table number is 0");
        }
        ShardingDBResource dbResource = null;
        String clusterName = ReflectUtil.getClusterName(clazz);
        String tableName = ReflectUtil.getTableName(clazz);
        DBClusterInfo dbClusterInfo = this.getDBClusterInfo(clusterName);
        for (DBClusterRegionInfo region : dbClusterInfo.getDbRegions()) {
            for (DBInfo dbInfo : region.getSlaveDBInfos().get(slave.getValue())) {
                for (int tableIndex = 0; tableIndex < tableNum; ++tableIndex) {
                    dbResource = ShardingDBResource.valueOf(dbInfo, region, tableName, tableIndex);
                    dbResources.add(dbResource);
                }
            }
        }
        return dbResources;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.primaryCache;
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.secondCache;
    }

    @Override
    public Lock createLock(String lockName) {
        InterProcessMutex curatorLock = new InterProcessMutex(this.curatorClient, "/pinus/locks/" + lockName);
        return new CuratorDistributeedLock(curatorLock);
    }

    @Override
    public IDataLayerBuilder getDataLayerBuilder() {
        IDataLayerBuilder builder = JdbcDataLayerBuilder.valueOf(this);
        builder.setPrimaryCache(this.primaryCache);
        builder.setSecondCache(this.secondCache);
        return builder;
    }

    @Override
    public void setShardInfoFromZk(boolean value) {
        this.isShardInfoFromZk = value;
    }

    @Override
    public List<DBTable> getDBTableFromZk() {
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        try {
            ZooKeeper zkClient = this.curatorClient.getZookeeperClient().getZooKeeper();
            List zkTableNodes = zkClient.getChildren("/pinus/shardinginfo", false);
            byte[] tableData = null;
            for (String zkTableNode : zkTableNodes) {
                tableData = zkClient.getData("/pinus/shardinginfo/" + zkTableNode, false, null);
                tables.add(IOUtil.getObject(tableData, DBTable.class));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tables;
    }

    @Override
    public List<DBTable> getDBTableFromJvm() {
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        try {
            for (String pkgPath : this.scanPackage.split(",")) {
                tables.addAll(this.dbGenerator.scanEntity(pkgPath));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tables;
    }

    private void _syncToZookeeper(List<DBTable> tables) throws Exception {
        try {
            ZooKeeper zkClient = this.curatorClient.getZookeeperClient().getZooKeeper();
            Stat stat = zkClient.exists("/pinus/shardinginfo", false);
            if (stat == null) {
                zkClient.create("/pinus/shardinginfo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            byte[] tableData = null;
            String tableName = null;
            for (DBTable table : tables) {
                tableData = IOUtil.getBytes(table);
                tableName = table.getName();
                String zkTableNode = "/pinus/shardinginfo/" + tableName;
                stat = zkClient.exists(zkTableNode, false);
                if (stat == null) {
                    zkClient.create(zkTableNode, tableData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    continue;
                }
                zkClient.setData(zkTableNode, tableData, -1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("sharding info of tables have flushed to zookeeper done.");
    }

    private void _createTable(List<DBTable> tables) throws Exception {
        String clusterName = null;
        for (DBTable table : tables) {
            List<DBInfo> slaveDbs;
            DataSource globalDs;
            DBClusterInfo dbClusterInfo;
            clusterName = table.getCluster();
            if (table.getShardingNum() > 0) {
                dbClusterInfo = this.dbClusterInfoC.find(clusterName);
                if (dbClusterInfo == null) {
                    throw new DBClusterException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u96c6\u7fa4\u4fe1\u606f, clusterName=" + clusterName);
                }
                for (DBClusterRegionInfo region : dbClusterInfo.getDbRegions()) {
                    for (DBInfo dBInfo : region.getMasterDBInfos()) {
                        Connection dbConn = dBInfo.getDatasource().getConnection();
                        int tableNum = table.getShardingNum();
                        this.dbGenerator.syncTable(dbConn, table, tableNum);
                        dbConn.close();
                    }
                }
                for (DBClusterRegionInfo region : dbClusterInfo.getDbRegions()) {
                    List<List<DBInfo>> slaveDbs2 = region.getSlaveDBInfos();
                    for (List<DBInfo> slaveConns : slaveDbs2) {
                        for (DBInfo dbConnInfo : slaveConns) {
                            Connection dbConn = dbConnInfo.getDatasource().getConnection();
                            int tableNum = table.getShardingNum();
                            this.dbGenerator.syncTable(dbConn, table, tableNum);
                            dbConn.close();
                        }
                    }
                }
                continue;
            }
            dbClusterInfo = this.dbClusterInfoC.find(clusterName);
            if (dbClusterInfo == null) {
                throw new DBClusterException("\u52a0\u8f7d\u96c6\u7fa4\u5931\u8d25\uff0c\u672a\u77e5\u7684\u96c6\u7fa4\uff0ccluster name=" + clusterName);
            }
            DBInfo dbConnInfo = dbClusterInfo.getMasterGlobalDBInfo();
            if (dbConnInfo != null && (globalDs = dbConnInfo.getDatasource()) != null) {
                Connection conn = globalDs.getConnection();
                this.dbGenerator.syncTable(conn, table);
                conn.close();
            }
            if ((slaveDbs = dbClusterInfo.getSlaveGlobalDBInfo()) == null || slaveDbs.isEmpty()) continue;
            for (DBInfo dBInfo : slaveDbs) {
                Connection conn = dBInfo.getDatasource().getConnection();
                this.dbGenerator.syncTable(conn, table);
                conn.close();
            }
        }
    }

    private void _initDBCluster(Collection<DBClusterInfo> dbClusterInfos) throws LoadConfigException {
        this.dbClusterInfoC = DefaultContainerFactory.createContainer(DefaultContainerFactory.ContainerType.MAP);
        for (DBClusterInfo dbClusterInfo : dbClusterInfos) {
            List<DBInfo> slaveDbs;
            LOG.info("init db cluster " + dbClusterInfo.getClusterName() + ", router is [" + dbClusterInfo.getRouterClass().getName() + "]");
            this.dbClusterInfoC.add(dbClusterInfo.getClusterName(), dbClusterInfo);
            DBInfo masterGlobalDBInfo = dbClusterInfo.getMasterGlobalDBInfo();
            if (masterGlobalDBInfo != null) {
                this.buildDataSource(masterGlobalDBInfo);
                this._initDatabaseName(masterGlobalDBInfo);
            }
            if ((slaveDbs = dbClusterInfo.getSlaveGlobalDBInfo()) != null && !slaveDbs.isEmpty()) {
                for (DBInfo slaveGlobalDBInfo : slaveDbs) {
                    this.buildDataSource(slaveGlobalDBInfo);
                    this._initDatabaseName(slaveGlobalDBInfo);
                }
            }
            for (DBClusterRegionInfo regionInfo : dbClusterInfo.getDbRegions()) {
                for (DBInfo dBInfo : regionInfo.getMasterDBInfos()) {
                    this.buildDataSource(dBInfo);
                    this._initDatabaseName(dBInfo);
                }
                for (List list : regionInfo.getSlaveDBInfos()) {
                    for (DBInfo slaveDBInfo : list) {
                        this.buildDataSource(slaveDBInfo);
                        this._initDatabaseName(slaveDBInfo);
                    }
                }
            }
        }
    }

    private void _initDatabaseName(DBInfo dbInfo) {
        DataSource ds = dbInfo.getDatasource();
        if (ds != null) {
            Connection conn = null;
            try {
                conn = ds.getConnection();
                String dbName = conn.getCatalog();
                dbInfo.setDbName(dbName);
            }
            catch (Exception e) {
                throw new RuntimeException("get database name failure ", e);
            }
            finally {
                SQLBuilder.close(conn);
            }
        }
    }

    private IClusterConfig _getConfig(String xmlFilePath) throws LoadConfigException {
        IClusterConfig config = null;
        config = StringUtils.isBlank(xmlFilePath) ? XmlClusterConfigImpl.getInstance() : XmlClusterConfigImpl.getInstance(xmlFilePath);
        return config;
    }

    public abstract void buildDataSource(DBInfo var1) throws LoadConfigException;

    public abstract void closeDataSource(DBInfo var1);

    public EnumSyncAction getSyncAction() {
        return this.syncAction;
    }

    @Override
    public void setSyncAction(EnumSyncAction syncAction) {
        this.syncAction = syncAction;
    }

    @Override
    public IIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    @Override
    public ITableCluster getTableCluster() {
        return this.tableCluster;
    }
}

