/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.impl;

import java.util.List;
import org.pinus4j.cluster.ITableCluster;
import org.pinus4j.cluster.ITableClusterBuilder;
import org.pinus4j.cluster.beans.TableNumberInfo;
import org.pinus4j.cluster.impl.NumberIndexTableCluster;
import org.pinus4j.generator.beans.DBTable;

public class NumberIndexTableClusterBuilder
implements ITableClusterBuilder {
    private List<DBTable> tables;

    private NumberIndexTableClusterBuilder() {
    }

    public static ITableClusterBuilder valueOf(List<DBTable> tables) {
        NumberIndexTableClusterBuilder builder = new NumberIndexTableClusterBuilder();
        builder.setTables(tables);
        return builder;
    }

    @Override
    public ITableCluster build() {
        NumberIndexTableCluster tableCluster = new NumberIndexTableCluster();
        String clusterName = null;
        TableNumberInfo tableNumberInfo = null;
        for (DBTable dbTable : this.tables) {
            clusterName = dbTable.getCluster();
            tableNumberInfo = tableCluster.getTableNumberInfo(clusterName);
            if (tableNumberInfo == null) {
                tableNumberInfo = TableNumberInfo.valueOf(clusterName);
                tableCluster.addTableNumberInfo(clusterName, tableNumberInfo);
            }
            tableNumberInfo.add(dbTable.getName(), dbTable.getShardingNum());
        }
        return tableCluster;
    }

    public void setTables(List<DBTable> tables) {
        this.tables = tables;
    }
}

