/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.resources;

import java.util.Map;
import java.util.WeakHashMap;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.IResourceId;

public class DBResourceCache {
    private static final Map<IResourceId, IDBResource> globalDBResourceCache = new WeakHashMap<IResourceId, IDBResource>();
    private static final Map<IResourceId, IDBResource> shardingDBResourceCache = new WeakHashMap<IResourceId, IDBResource>();

    public static IDBResource getGlobalDBResource(IResourceId resId) {
        return globalDBResourceCache.get(resId);
    }

    public static void putGlobalDBResource(IResourceId resId, IDBResource globalDBResource) {
        globalDBResourceCache.put(resId, globalDBResource);
    }

    public static IDBResource getShardingDBResource(IResourceId resId) {
        return shardingDBResourceCache.get(resId);
    }

    public static void putShardingDBResource(IResourceId resId, IDBResource shardingDBResource) {
        shardingDBResourceCache.put(resId, shardingDBResource);
    }

    public static void clear() {
        globalDBResourceCache.clear();
        shardingDBResourceCache.clear();
    }
}

