/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.resources;

import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.resources.IResourceId;

public class DBResourceId
implements IResourceId {
    private String clusterName;
    private String dbName;
    private long regionStart;
    private long regionEnd;
    private String tableName;
    private int tableIndex;
    private EnumDBMasterSlave masterSlave;

    public DBResourceId(String clusterName, String dbName, String tableName, EnumDBMasterSlave masterSlave) {
        this(clusterName, dbName, -1L, -1L, tableName, -1, masterSlave);
    }

    public DBResourceId(String clusterName, String dbName, long regionStart, long regionEnd, String tableName, int tableIndex, EnumDBMasterSlave masterSlave) {
        this.clusterName = clusterName;
        this.dbName = dbName;
        this.regionStart = regionStart;
        this.regionEnd = regionEnd;
        this.tableName = tableName;
        this.tableIndex = tableIndex;
        this.masterSlave = masterSlave;
    }

    @Override
    public String value() {
        StringBuilder value = new StringBuilder();
        value.append(this.clusterName);
        value.append(this.dbName);
        value.append(this.regionStart);
        value.append(this.regionEnd);
        value.append(this.tableName);
        value.append(this.tableIndex);
        value.append(this.masterSlave.getValue());
        return value.toString();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public long getRegionStart() {
        return this.regionStart;
    }

    public void setRegionStart(long regionStart) {
        this.regionStart = regionStart;
    }

    public long getRegionEnd() {
        return this.regionEnd;
    }

    public void setRegionEnd(long regionEnd) {
        this.regionEnd = regionEnd;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }

    public EnumDBMasterSlave getMasterSlave() {
        return this.masterSlave;
    }

    public void setMasterSlave(EnumDBMasterSlave masterSlave) {
        this.masterSlave = masterSlave;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = 31 * result + (this.dbName == null ? 0 : this.dbName.hashCode());
        result = 31 * result + (this.masterSlave == null ? 0 : this.masterSlave.hashCode());
        result = 31 * result + (int)(this.regionEnd ^ this.regionEnd >>> 32);
        result = 31 * result + (int)(this.regionStart ^ this.regionStart >>> 32);
        result = 31 * result + this.tableIndex;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBResourceId other = (DBResourceId)obj;
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        if (this.dbName == null ? other.dbName != null : !this.dbName.equals(other.dbName)) {
            return false;
        }
        if (this.masterSlave != other.masterSlave) {
            return false;
        }
        if (this.regionEnd != other.regionEnd) {
            return false;
        }
        if (this.regionStart != other.regionStart) {
            return false;
        }
        if (this.tableIndex != other.tableIndex) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }
}

