/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.resources;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.resources.AbstractXADBResource;
import org.pinus4j.cluster.resources.DBResourceCache;
import org.pinus4j.cluster.resources.DBResourceId;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.IResourceId;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;

public class GlobalDBResource
extends AbstractXADBResource {
    private IResourceId resId;
    private Connection conn;
    private String clusterName;
    private String dbName;
    private EnumDBMasterSlave masterSlave;
    private String databaseProductName;
    private String host;
    private String catalog;

    private GlobalDBResource() {
    }

    public static IDBResource valueOf(DBInfo dbInfo, String tableName) throws SQLException {
        DBResourceId resId = new DBResourceId(dbInfo.getClusterName(), dbInfo.getDbName(), tableName, dbInfo.getMasterSlave());
        GlobalDBResource instance = (GlobalDBResource)DBResourceCache.getGlobalDBResource(resId);
        Connection conn = dbInfo.getDatasource().getConnection();
        conn.setAutoCommit(false);
        if (instance == null) {
            instance = new GlobalDBResource();
            instance.setId(resId);
            instance.setClusterName(dbInfo.getClusterName());
            instance.setDbName(dbInfo.getDbName());
            instance.setMasterSlave(dbInfo.getMasterSlave());
            DatabaseMetaData dbMeta = conn.getMetaData();
            String databaseProductName = dbMeta.getDatabaseProductName();
            String url = dbMeta.getURL().substring(13);
            String host = url.substring(0, url.indexOf("/"));
            String catalog = conn.getCatalog();
            instance.setDatabaseProductName(databaseProductName);
            instance.setHost(host);
            instance.setCatalog(catalog);
            DBResourceCache.putGlobalDBResource(resId, instance);
        }
        instance.setConnection(conn);
        return instance;
    }

    public void setId(IResourceId resId) {
        this.resId = resId;
    }

    @Override
    public IResourceId getId() {
        return this.resId;
    }

    @Override
    public void setTransactionIsolationLevel(EnumTransactionIsolationLevel txLevel) {
        try {
            this.conn.setTransactionIsolation(txLevel.getLevel());
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public EnumDBMasterSlave getMasterSlave() {
        return this.masterSlave;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setMasterSlave(EnumDBMasterSlave masterSlave) {
        this.masterSlave = masterSlave;
    }
}

