/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.resources;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.beans.DBClusterRegionInfo;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.resources.AbstractXADBResource;
import org.pinus4j.cluster.resources.DBResourceCache;
import org.pinus4j.cluster.resources.DBResourceId;
import org.pinus4j.cluster.resources.IResourceId;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;

public class ShardingDBResource
extends AbstractXADBResource {
    private IResourceId resId;
    private Connection connection;
    private String clusterName;
    private String dbName;
    private String tableName;
    private int tableIndex;
    private long regionStart;
    private long regionEnd;
    private EnumDBMasterSlave masterSlave;
    private String databaseProductName;
    private String host;
    private String catalog;

    private ShardingDBResource() {
    }

    public static ShardingDBResource valueOf(DBInfo dbInfo, DBClusterRegionInfo regionInfo, String tableName, int tableIndex) throws SQLException {
        DBResourceId resId = new DBResourceId(dbInfo.getClusterName(), dbInfo.getDbName(), regionInfo.getStart(), regionInfo.getEnd(), tableName, tableIndex, dbInfo.getMasterSlave());
        ShardingDBResource instance = (ShardingDBResource)DBResourceCache.getShardingDBResource(resId);
        Connection conn = dbInfo.getDatasource().getConnection();
        conn.setAutoCommit(false);
        if (instance == null) {
            instance = new ShardingDBResource();
            instance.setId(resId);
            instance.setClusterName(dbInfo.getClusterName());
            instance.setDbName(dbInfo.getDbName());
            instance.setTableName(tableName);
            instance.setTableIndex(tableIndex);
            instance.setRegionStart(regionInfo.getStart());
            instance.setRegionEnd(regionInfo.getEnd());
            instance.setMasterSlave(dbInfo.getMasterSlave());
            DatabaseMetaData dbMeta = conn.getMetaData();
            String databaseProductName = dbMeta.getDatabaseProductName();
            String url = dbMeta.getURL().substring(13);
            String host = url.substring(0, url.indexOf("/"));
            String catalog = conn.getCatalog();
            instance.setDatabaseProductName(databaseProductName);
            instance.setHost(host);
            instance.setCatalog(catalog);
            DBResourceCache.putShardingDBResource(resId, instance);
        }
        instance.setConnection(conn);
        return instance;
    }

    public void setId(IResourceId resId) {
        this.resId = resId;
    }

    @Override
    public IResourceId getId() {
        return this.resId;
    }

    @Override
    public void setTransactionIsolationLevel(EnumTransactionIsolationLevel txLevel) {
        try {
            this.connection.setTransactionIsolation(txLevel.getLevel());
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    @Override
    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public EnumDBMasterSlave getMasterSlave() {
        return this.masterSlave;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append(this.databaseProductName);
        info.append(" host=" + this.host);
        info.append(" db=").append(this.catalog);
        info.append(" tableName=").append(this.tableName).append(this.tableIndex);
        info.append(" start=").append(this.regionStart).append(" end=").append(this.regionEnd);
        return info.toString();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public long getRegionStart() {
        return this.regionStart;
    }

    public void setRegionStart(long regionStart) {
        this.regionStart = regionStart;
    }

    public long getRegionEnd() {
        return this.regionEnd;
    }

    public void setRegionEnd(long regionEnd) {
        this.regionEnd = regionEnd;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setMasterSlave(EnumDBMasterSlave masterSlave) {
        this.masterSlave = masterSlave;
    }
}

