/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.cluster.router.impl;

import java.util.List;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.ITableCluster;
import org.pinus4j.cluster.beans.DBClusterInfo;
import org.pinus4j.cluster.beans.DBClusterRegionInfo;
import org.pinus4j.cluster.beans.DBInfo;
import org.pinus4j.cluster.enums.HashAlgoEnum;
import org.pinus4j.cluster.router.IClusterRouter;
import org.pinus4j.cluster.router.RouteInfo;
import org.pinus4j.exceptions.DBRouteException;

public abstract class AbstractClusterRouter
implements IClusterRouter {
    private HashAlgoEnum hashAlgo;
    private IDBCluster dbCluster;
    private ITableCluster tableCluster;

    @Override
    public void setHashAlgo(HashAlgoEnum algoEnum) {
        this.hashAlgo = algoEnum;
    }

    @Override
    public HashAlgoEnum getHashAlgo() {
        return this.hashAlgo;
    }

    @Override
    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public void setTableCluster(ITableCluster tableCluster) {
        this.tableCluster = tableCluster;
    }

    @Override
    public ITableCluster getTableCluster() {
        return this.tableCluster;
    }

    @Override
    public RouteInfo select(EnumDBMasterSlave clusterType, String tableName, IShardingKey<?> value) throws DBRouteException {
        RouteInfo dbRouteInfo = new RouteInfo();
        long shardingValue = this.getShardingValue(value);
        String clusterName = value.getClusterName();
        DBClusterInfo dbClusterInfo = this.dbCluster.getDBClusterInfo(clusterName);
        if (dbClusterInfo == null) {
            throw new IllegalStateException("can not found cluster " + clusterName);
        }
        List<DBClusterRegionInfo> regionInfos = dbClusterInfo.getDbRegions();
        if (regionInfos == null || regionInfos.isEmpty()) {
            throw new DBRouteException("\u67e5\u627e\u96c6\u7fa4\u5931\u8d25, clustername=" + clusterName);
        }
        DBClusterRegionInfo regionInfo = null;
        int regionIndex = 0;
        for (DBClusterRegionInfo region : regionInfos) {
            if (region.getStart() <= shardingValue && region.getEnd() >= shardingValue) {
                regionInfo = region;
                break;
            }
            ++regionIndex;
        }
        if (regionInfo == null) {
            throw new DBRouteException("find db cluster failure, over capacity, cluster name is " + clusterName + ", sharding value is " + shardingValue);
        }
        List<DBInfo> dbInfos = null;
        switch (clusterType) {
            case MASTER: {
                dbInfos = regionInfo.getMasterDBInfos();
                break;
            }
            default: {
                List<List<DBInfo>> multiSlaveDBInfos = regionInfo.getSlaveDBInfos();
                if (multiSlaveDBInfos == null || multiSlaveDBInfos.isEmpty()) {
                    throw new DBRouteException("find slave db cluster failure cluster name is " + clusterName);
                }
                int slaveIndex = clusterType.getValue();
                dbInfos = multiSlaveDBInfos.get(slaveIndex);
            }
        }
        if (dbInfos == null || dbInfos.isEmpty()) {
            throw new DBRouteException("find db cluster failure, cluster name is " + clusterName);
        }
        DBInfo dbInfo = this.doSelect(dbInfos, value);
        dbRouteInfo.setDbInfo(dbInfo);
        dbRouteInfo.setClusterName(clusterName);
        dbRouteInfo.setRegionIndex(regionIndex);
        try {
            int tableNum = this.tableCluster.getTableNumber(clusterName, tableName);
            int tableIndex = (int)shardingValue % tableNum;
            dbRouteInfo.setTableName(tableName);
            dbRouteInfo.setTableIndex(tableIndex);
        }
        catch (Exception e) {
            throw new DBRouteException("find table failure, cluster name is " + dbRouteInfo.getClusterName() + "db name is " + dbRouteInfo.getDbInfo().getDbName() + ", table name is " + tableName);
        }
        return dbRouteInfo;
    }

    protected long getShardingValue(IShardingKey<?> value) {
        Object shardingValue = value.getValue();
        if (shardingValue instanceof String) {
            return (int)this.hashAlgo.hash((String)shardingValue);
        }
        if (shardingValue instanceof Integer) {
            return ((Integer)shardingValue).intValue();
        }
        if (shardingValue instanceof Long) {
            return (Long)shardingValue;
        }
        throw new IllegalArgumentException("sharding value\u7684\u503c\u53ea\u80fd\u662fString\u6216\u8005Number " + shardingValue);
    }

    protected abstract DBInfo doSelect(List<DBInfo> var1, IShardingKey<?> var2) throws DBRouteException;
}

