/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.datalayer.SQLParser;
import org.pinus4j.utils.ReflectUtil;
import org.pinus4j.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(SQLBuilder.class);
    private static final Map<String, String> _selectCountCache = new ConcurrentHashMap<String, String>();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String buildSelectPkByQuery(Class<?> clazz, int tableIndex, IQuery query) {
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("SELECT " + pkName + " FROM ");
        SQL2.append(tableName);
        String whereSql = query.getWhereSql();
        if (StringUtils.isNotBlank(whereSql)) {
            SQL2.append(query.getWhereSql());
        }
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildSelectByQuery(Class<?> clazz, int tableIndex, IQuery query) {
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        StringBuilder fields = new StringBuilder();
        if (query.hasQueryFields()) {
            for (String field : query.getFields()) {
                fields.append(field).append(",");
            }
            fields.deleteCharAt(fields.length() - 1);
        } else {
            fields.append("*");
        }
        StringBuilder SQL2 = new StringBuilder("SELECT ");
        SQL2.append(fields.toString()).append(" FROM ");
        SQL2.append(tableName);
        String whereSql = query.getWhereSql();
        if (StringUtils.isNotBlank(whereSql)) {
            SQL2.append(query.getWhereSql());
        }
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildSelectCountByQuery(Class<?> clazz, int tableIndex, IQuery query) {
        String whereSql;
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("SELECT count(" + pkName + ") FROM ");
        SQL2.append(tableName);
        if (query != null && StringUtils.isNotBlank(whereSql = query.getWhereSql())) {
            SQL2.append(query.getWhereSql());
        }
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static PreparedStatement buildSelectBySqlGlobal(Connection conn, SQL sql) throws SQLException {
        SQLBuilder.debugSQL(sql.toString());
        PreparedStatement ps = conn.prepareStatement(sql.getSql());
        Object[] params = sql.getParams();
        if (params != null) {
            for (int i = 1; i <= params.length; ++i) {
                ps.setObject(i, params[i - 1]);
            }
        }
        return ps;
    }

    public static PreparedStatement buildSelectBySql(Connection conn, SQL sql, int tableIndex) throws SQLException {
        String s = SQLParser.addTableIndex(sql.getSql(), tableIndex);
        SQLBuilder.debugSQL(sql.toString());
        PreparedStatement ps = conn.prepareStatement(s);
        Object[] params = sql.getParams();
        if (params != null) {
            for (int i = 1; i <= params.length; ++i) {
                ps.setObject(i, params[i - 1]);
            }
        }
        return ps;
    }

    public static String buildSelectCountGlobalSql(Class<?> clazz) {
        return SQLBuilder.buildSelectCountGlobalSql(clazz, null);
    }

    public static String buildSelectCountGlobalSql(Class<?> clazz, IQuery query) {
        String tableName = ReflectUtil.getTableName(clazz, -1);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("SELECT count(" + pkName + ") ").append("FROM ");
        SQL2.append(tableName);
        if (query != null) {
            SQL2.append(query.getWhereSql());
        }
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildSelectCountSql(Class<?> clazz, int tableIndex) {
        String sql = _selectCountCache.get(clazz.getName() + tableIndex);
        if (sql != null) {
            SQLBuilder.debugSQL(sql);
            return sql;
        }
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("SELECT count(" + pkName + ") ").append("FROM ");
        SQL2.append(tableName);
        SQLBuilder.debugSQL(SQL2.toString());
        _selectCountCache.put(clazz.getName() + tableIndex, SQL2.toString());
        return SQL2.toString();
    }

    public static List<Map<String, Object>> buildResultObject(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, Object> one = null;
        while (rs.next()) {
            try {
                one = new HashMap<String, Object>();
                String fieldName = null;
                Object value = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    value = rs.getObject(i);
                    one.put(fieldName, value);
                }
                list.add(one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return list;
    }

    public static <T> List<T> buildResultObject(Class<T> clazz, ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        Object one = null;
        while (rs.next()) {
            try {
                one = clazz.newInstance();
                String fieldName = null;
                Field f = null;
                Object value = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    try {
                        f = clazz.getDeclaredField(fieldName);
                        value = SQLBuilder._getRsValue(rs, f, i);
                        ReflectUtil.setProperty(one, fieldName, value);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
                list.add(one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return list;
    }

    public static <T> Map<Number, T> buildResultObjectAsMap(Class<T> clazz, ResultSet rs) throws SQLException {
        HashMap<Number, Object> map = new HashMap<Number, Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        Object one = null;
        while (rs.next()) {
            try {
                one = clazz.newInstance();
                String fieldName = null;
                String pkName = ReflectUtil.getPkName(clazz);
                Field f = null;
                Object value = null;
                Number pkValue = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    f = clazz.getDeclaredField(fieldName);
                    pkValue = (Number)rs.getObject(pkName);
                    value = SQLBuilder._getRsValue(rs, f, i);
                    ReflectUtil.setProperty(one, fieldName, value);
                }
                map.put(pkValue, one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return map;
    }

    private static Object _getRsValue(ResultSet rs, Field f, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
            value = rs.getString(i).equals("1");
        } else if (f.getType() == Byte.TYPE || f.getType() == Byte.class) {
            value = rs.getByte(i);
        } else if (f.getType() == Character.TYPE || f.getType() == Character.class) {
            String s = rs.getString(i);
            value = s.length() > 0 ? Character.valueOf(rs.getString(i).charAt(0)) : new Character('\u0000');
        } else if (f.getType() == Short.TYPE || f.getType() == Short.class) {
            value = rs.getShort(i);
        }
        return value;
    }

    public static String buildSelectByPks(Class<?> clazz, int tableIndex, Number[] pks) {
        Field[] fields = ReflectUtil.getFields(clazz);
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder sqlInValue = new StringBuilder();
        for (Number pk : pks) {
            sqlInValue.append(pk).append(",");
        }
        sqlInValue.deleteCharAt(sqlInValue.length() - 1);
        StringBuilder SQL2 = new StringBuilder("SELECT ");
        for (Field field : fields) {
            SQL2.append(field.getName()).append(",");
        }
        SQL2.deleteCharAt(SQL2.length() - 1);
        SQL2.append(" FROM ").append(tableName);
        SQL2.append(" WHERE ").append(pkName).append(" in (");
        SQL2.append(sqlInValue.toString());
        SQL2.append(") order by field(");
        SQL2.append(pkName).append(",").append(sqlInValue.toString());
        SQL2.append(")");
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildSelectByPk(Number pk, Class<?> clazz, int tableIndex) throws SQLException {
        Field[] fields = ReflectUtil.getFields(clazz);
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("SELECT ");
        for (Field field : fields) {
            SQL2.append(field.getName()).append(",");
        }
        SQL2.deleteCharAt(SQL2.length() - 1);
        SQL2.append(" FROM ").append(tableName);
        SQL2.append(" WHERE ").append(pkName).append("=").append(pk.longValue());
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildDeleteByPks(Class<?> clazz, int tableIndex, List<? extends Number> pks) {
        String tableName = ReflectUtil.getTableName(clazz, tableIndex);
        String pkName = ReflectUtil.getPkName(clazz);
        StringBuilder SQL2 = new StringBuilder("DELETE FROM ").append(tableName);
        SQL2.append(" WHERE ").append(pkName).append(" IN (");
        for (Number number : pks) {
            if (number.longValue() <= 0L) continue;
            SQL2.append(number.longValue()).append(",");
        }
        SQL2.deleteCharAt(SQL2.length() - 1);
        SQL2.append(")");
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static Statement getUpdate(Connection conn, List<? extends Object> entities, int tableIndex) throws SQLException {
        Object entity = entities.get(0);
        Class<?> entityClass = entity.getClass();
        String tableName = ReflectUtil.getTableName(entity, tableIndex);
        String pkName = ReflectUtil.getPkName(entityClass);
        Statement st = conn.createStatement();
        Map<String, Object> entityProperty = null;
        for (Object object : entities) {
            try {
                entityProperty = ReflectUtil.describeWithoutUpdateTime(object, true);
            }
            catch (Exception e) {
                throw new SQLException("\u89e3\u6790\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25", e);
            }
            Object pkValue = entityProperty.get(pkName);
            entityProperty.remove(pkName);
            Set<Map.Entry<String, Object>> propertyEntrySet = entityProperty.entrySet();
            StringBuilder SQL2 = new StringBuilder("UPDATE " + tableName + " SET ");
            Object value = null;
            for (Map.Entry<String, Object> propertyEntry : propertyEntrySet) {
                value = propertyEntry.getValue();
                SQL2.append(propertyEntry.getKey()).append("=");
                SQL2.append(SQLBuilder.formatValue(value));
                SQL2.append(",");
            }
            SQL2.deleteCharAt(SQL2.length() - 1);
            SQL2.append(" WHERE ").append(pkName).append("=").append(pkValue);
            st.addBatch(SQL2.toString());
            SQLBuilder.debugSQL(SQL2.toString());
        }
        return st;
    }

    public static Statement getInsert(Connection conn, List<? extends Object> entities, int tableIndex) throws SQLException {
        Object entity = entities.get(0);
        String tableName = ReflectUtil.getTableName(entity, tableIndex);
        Statement st = conn.createStatement();
        Map<String, Object> entityProperty = null;
        for (Object object : entities) {
            try {
                entityProperty = ReflectUtil.describe(object, true);
            }
            catch (Exception e) {
                throw new SQLException("\u89e3\u6790\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25", e);
            }
            Set<Map.Entry<String, Object>> propertyEntrySet = entityProperty.entrySet();
            StringBuilder SQL2 = new StringBuilder("INSERT INTO " + tableName + "(");
            StringBuilder var = new StringBuilder();
            Object value = null;
            for (Map.Entry<String, Object> propertyEntry : propertyEntrySet) {
                value = propertyEntry.getValue();
                SQL2.append(propertyEntry.getKey()).append(",");
                var.append(SQLBuilder.formatValue(value));
                var.append(",");
            }
            SQL2.deleteCharAt(SQL2.length() - 1);
            SQL2.append(") VALUES (");
            SQL2.append(var.deleteCharAt(var.length() - 1).toString());
            SQL2.append(")");
            st.addBatch(SQL2.toString());
            SQLBuilder.debugSQL(SQL2.toString());
        }
        return st;
    }

    public static Object formatValue(Object value) {
        Object format = null;
        if (value instanceof String) {
            String content = (String)value;
            format = "'" + content.replaceAll("'", "''") + "'";
        } else {
            format = value instanceof Character ? (((Character)value).charValue() == '\'' ? "'\\" + (Character)value + "'" : "'" + (Character)value + "'") : (value instanceof Date ? "'" + sdf.format((Date)value) + "'" : value);
        }
        return format;
    }

    public static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void close(PreparedStatement ps) {
        SQLBuilder.close(ps, null);
    }

    public static void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void close(PreparedStatement ps, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void debugSQL(String sql) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(sql);
        }
    }
}

