/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.iterator;

import java.sql.SQLException;
import java.util.List;
import org.pinus4j.api.query.Condition;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.Order;
import org.pinus4j.api.query.QueryImpl;
import org.pinus4j.cluster.resources.GlobalDBResource;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.iterator.AbstractRecordIterator;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRecordIterator<E>
extends AbstractRecordIterator<E> {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalRecordIterator.class);
    private IDBResource dbResource;

    public GlobalRecordIterator(GlobalDBResource dbResource, Class<E> clazz) {
        super(clazz);
        this.dbResource = dbResource;
        this.maxId = this.getMaxId();
    }

    @Override
    public long getMaxId() {
        List one;
        long maxId = 0L;
        QueryImpl query = new QueryImpl();
        query.limit(1).orderBy(this.pkName, Order.DESC);
        try {
            one = this.selectGlobalByQuery(this.dbResource, query, this.clazz);
        }
        catch (SQLException e1) {
            throw new DBOperationException(e1);
        }
        if (!one.isEmpty()) {
            Object e = one.get(0);
            maxId = ReflectUtil.getPkValue(e).longValue();
        }
        LOG.info("clazz " + this.clazz + " maxId=" + maxId);
        return maxId;
    }

    @Override
    public long getCount() {
        try {
            return this.selectGlobalCount(this.query, this.dbResource, this.dbResource.getClusterName(), this.clazz).longValue();
        }
        catch (SQLException e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordQ.isEmpty()) {
            IQuery query = this.query.clone();
            long high = this.latestId + (long)this.step;
            query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
            try {
                List recrods = this.selectGlobalByQuery(this.dbResource, query, this.clazz);
                this.latestId = high;
                while (recrods.isEmpty() && this.latestId < this.maxId) {
                    query = this.query.clone();
                    high = this.latestId + (long)this.step;
                    query.add(Condition.gte(this.pkName, this.latestId)).add(Condition.lt(this.pkName, high));
                    recrods = this.selectGlobalByQuery(this.dbResource, query, this.clazz);
                    this.latestId = high;
                }
                this.recordQ.addAll(recrods);
            }
            catch (SQLException e) {
                throw new DBOperationException(e);
            }
        }
        return !this.recordQ.isEmpty();
    }
}

