/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.IDataQuery;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.SlowQueryLogger;
import org.pinus4j.utils.ReflectUtil;

public abstract class AbstractJdbcQuery
implements IDataQuery {
    protected IDBCluster dbCluster;
    protected IPrimaryCache primaryCache;
    protected ISecondCache secondCache;
    protected TransactionManager txManager;

    protected boolean isCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.primaryCache != null && ReflectUtil.isCache(clazz) && useCache;
    }

    protected boolean isSecondCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.secondCache != null && ReflectUtil.isCache(clazz) && useCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number _selectGlobalCount(IDBResource dbResource, Class<?> clazz) throws SQLException {
        Long l;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectCountGlobalSql(clazz);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number selectGlobalCount(IQuery query, IDBResource dbResource, String clusterName, Class<?> clazz) throws SQLException {
        long count = 0L;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectCountGlobalSql(clazz, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return count;
    }

    protected Number selectGlobalCountWithCache(IDBResource dbResource, String clusterName, Class<?> clazz, boolean useCache) throws SQLException {
        long count;
        String tableName = ReflectUtil.getTableName(clazz);
        if (this.isCacheAvailable(clazz, useCache) && (count = this.primaryCache.getCountGlobal(clusterName, tableName)) > 0L) {
            return count;
        }
        count = 0L;
        count = this._selectGlobalCount(dbResource, clazz).longValue();
        if (this.isCacheAvailable(clazz, useCache) && count > 0L) {
            this.primaryCache.setCountGlobal(clusterName, tableName, count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number _selectCount(ShardingDBResource db, Class<?> clazz) throws SQLException {
        Long l;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            String sql = SQLBuilder.buildSelectCountSql(clazz, db.getTableIndex());
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return l;
    }

    protected Number selectCountWithCache(ShardingDBResource db, Class<?> clazz, boolean useCache) throws SQLException {
        long count;
        if (this.isCacheAvailable(clazz, useCache) && (count = this.primaryCache.getCount(db)) > 0L) {
            return count;
        }
        count = this._selectCount(db, clazz).longValue();
        if (this.isCacheAvailable(clazz, useCache) && count > 0L) {
            this.primaryCache.setCount(db, count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number selectCount(ShardingDBResource db, Class<?> clazz, IQuery query) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            Long l;
            ps = null;
            rs = null;
            try {
                Connection conn = db.getConnection();
                String sql = SQLBuilder.buildSelectCountByQuery(clazz, db.getTableIndex(), query);
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 2000L) {
                    SlowQueryLogger.write(db, sql, constTime);
                }
                if (!rs.next()) break block3;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(ps, rs);
                throw throwable;
            }
            SQLBuilder.close(ps, rs);
            return l;
        }
        SQLBuilder.close(ps, rs);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _selectGlobalByPk(IDBResource dbResource, Number pk, Class<T> clazz) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            T t;
            ps = null;
            rs = null;
            try {
                List<T> result;
                Connection conn = dbResource.getConnection();
                String sql = SQLBuilder.buildSelectByPk(pk, clazz, -1);
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 1L) {
                    SlowQueryLogger.write(conn, sql, constTime);
                }
                if ((result = SQLBuilder.buildResultObject(clazz, rs)).isEmpty()) break block3;
                t = result.get(0);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(ps, rs);
                throw throwable;
            }
            SQLBuilder.close(ps, rs);
            return t;
        }
        SQLBuilder.close(ps, rs);
        return null;
    }

    protected <T> T selectByPkWithCache(IDBResource dbResource, String clusterName, Number pk, Class<T> clazz, boolean useCache) throws SQLException {
        String tableName = ReflectUtil.getTableName(clazz);
        T data = null;
        if (this.isCacheAvailable(clazz, useCache)) {
            data = this.primaryCache.getGlobal(clusterName, tableName, pk);
            if (data == null && (data = (T)this._selectGlobalByPk(dbResource, pk, clazz)) != null) {
                this.primaryCache.putGlobal(clusterName, tableName, pk, data);
            }
        } else {
            data = this._selectGlobalByPk(dbResource, pk, clazz);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _selectByPk(ShardingDBResource db, Number pk, Class<T> clazz) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            T t;
            ps = null;
            rs = null;
            try {
                List<T> result;
                Connection conn = db.getConnection();
                String sql = SQLBuilder.buildSelectByPk(pk, clazz, db.getTableIndex());
                ps = conn.prepareStatement(sql);
                long begin = System.currentTimeMillis();
                rs = ps.executeQuery();
                long constTime = System.currentTimeMillis() - begin;
                if (constTime > 1L) {
                    SlowQueryLogger.write(db, sql, constTime);
                }
                if ((result = SQLBuilder.buildResultObject(clazz, rs)).isEmpty()) break block3;
                t = result.get(0);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(ps, rs);
                throw throwable;
            }
            SQLBuilder.close(ps, rs);
            return t;
        }
        SQLBuilder.close(ps, rs);
        return null;
    }

    protected <T> T selectByPkWithCache(ShardingDBResource db, Number pk, Class<T> clazz, boolean useCache) throws SQLException {
        T data = null;
        if (this.isCacheAvailable(clazz, useCache)) {
            data = this.primaryCache.get(db, pk);
            if (data == null && (data = (T)this._selectByPk(db, pk, clazz)) != null) {
                this.primaryCache.put(db, pk, data);
            }
        } else {
            data = this._selectByPk(db, pk, clazz);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> _selectGlobalByPks(IDBResource dbResource, Class<T> clazz, Number[] pks) throws SQLException {
        List<Object> result = new ArrayList(1);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, -1, pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Number, T> _selectGlobalByPksWithMap(IDBResource dbResource, Class<T> clazz, Number[] pks) throws SQLException {
        Map<Object, Object> result = new HashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, -1, pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObjectAsMap(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    protected <T> List<T> selectGlobalByPksWithCache(IDBResource dbResource, String clusterName, Class<T> clazz, Number[] pks, boolean useCache) throws SQLException {
        List<Object> result = new ArrayList();
        if (pks == null || pks.length == 0) {
            return result;
        }
        if (this.isCacheAvailable(clazz, useCache)) {
            String tableName = ReflectUtil.getTableName(clazz);
            List hitResult = this.primaryCache.getGlobal(clusterName, tableName, pks);
            if (hitResult != null && !hitResult.isEmpty()) {
                if (hitResult.size() == pks.length) {
                    result = hitResult;
                } else {
                    try {
                        Map hitMap = this._getPkValues(hitResult);
                        ArrayList<Number> noHitPkList = new ArrayList<Number>();
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) continue;
                            noHitPkList.add(pk);
                        }
                        Number[] noHitPks = noHitPkList.toArray(new Number[noHitPkList.size()]);
                        Map<Number, T> noHitMap = this._selectGlobalByPksWithMap(dbResource, clazz, noHitPks);
                        if (!noHitMap.isEmpty()) {
                            this.primaryCache.putGlobal(clusterName, tableName, noHitMap);
                        }
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) {
                                result.add(hitMap.get(pk));
                                continue;
                            }
                            result.add(noHitMap.get(pk));
                        }
                    }
                    catch (Exception e) {
                        result = this._selectGlobalByPks(dbResource, clazz, pks);
                    }
                }
            } else {
                result = this._selectGlobalByPks(dbResource, clazz, pks);
                this.primaryCache.putGlobal(clusterName, tableName, result);
            }
        } else {
            result = this._selectGlobalByPks(dbResource, clazz, pks);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> _selectByPks(ShardingDBResource db, Class<T> clazz, Number[] pks) throws SQLException {
        List<Object> result = new ArrayList(1);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, db.getTableIndex(), pks);
            long begin = System.currentTimeMillis();
            ps = conn.prepareStatement(sql);
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            rs = ps.executeQuery();
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Number, T> selectByPksWithMap(ShardingDBResource db, Class<T> clazz, Number[] pks) throws SQLException {
        Map<Object, Object> result = new HashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            String sql = SQLBuilder.buildSelectByPks(clazz, db.getTableIndex(), pks);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObjectAsMap(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    protected <T> List<T> selectByPksWithCache(ShardingDBResource db, Class<T> clazz, Number[] pks, boolean useCache) throws SQLException {
        List<Object> result = new ArrayList();
        if (pks.length == 0 || pks == null) {
            return result;
        }
        if (this.isCacheAvailable(clazz, useCache)) {
            List hitResult = this.primaryCache.get(db, pks);
            if (hitResult != null && !hitResult.isEmpty()) {
                if (hitResult.size() == pks.length) {
                    result = hitResult;
                } else {
                    try {
                        Map hitMap = this._getPkValues(hitResult);
                        ArrayList<Number> noHitPkList = new ArrayList<Number>();
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) continue;
                            noHitPkList.add(pk);
                        }
                        Number[] noHitPks = noHitPkList.toArray(new Number[noHitPkList.size()]);
                        Map<Number, T> noHitMap = this.selectByPksWithMap(db, clazz, noHitPks);
                        if (!noHitMap.isEmpty()) {
                            this.primaryCache.put(db, noHitMap);
                        }
                        for (Number pk : pks) {
                            if (hitMap.get(pk) != null) {
                                result.add(hitMap.get(pk));
                                continue;
                            }
                            result.add(noHitMap.get(pk));
                        }
                    }
                    catch (Exception e) {
                        result = this._selectByPks(db, clazz, pks);
                    }
                }
            } else {
                result = this._selectByPks(db, clazz, pks);
                this.primaryCache.put(db, pks, result);
            }
        } else {
            result = this._selectByPks(db, clazz, pks);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> selectGlobalBySql(IDBResource dbResource, SQL sql) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            ps = SQLBuilder.buildSelectBySqlGlobal(conn, sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> selectBySql(ShardingDBResource db, SQL sql) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            ps = SQLBuilder.buildSelectBySql(conn, sql, db.getTableIndex());
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> selectGlobalByQuery(IDBResource dbResource, IQuery query, Class<T> clazz) throws SQLException {
        List<Object> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectByQuery(clazz, -1, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> selectByQuery(ShardingDBResource db, IQuery query, Class<T> clazz) throws SQLException {
        List<Object> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            String sql = SQLBuilder.buildSelectByQuery(clazz, db.getTableIndex(), query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            result = SQLBuilder.buildResultObject(clazz, rs);
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Number[] selectGlobalPksByQuery(IDBResource dbResource, IQuery query, Class<T> clazz) throws SQLException {
        ArrayList<Number> result = new ArrayList<Number>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = SQLBuilder.buildSelectPkByQuery(clazz, -1, query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            while (rs.next()) {
                result.add((Number)rs.getObject(1));
            }
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result.toArray(new Number[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Number[] selectPksByQuery(ShardingDBResource db, IQuery query, Class<T> clazz) throws SQLException {
        ArrayList<Number> result = new ArrayList<Number>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = db.getConnection();
            String sql = SQLBuilder.buildSelectPkByQuery(clazz, db.getTableIndex(), query);
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(db, sql, constTime);
            }
            while (rs.next()) {
                result.add((Number)rs.getObject(1));
            }
        }
        catch (Throwable throwable) {
            SQLBuilder.close(ps, rs);
            throw throwable;
        }
        SQLBuilder.close(ps, rs);
        return result.toArray(new Number[result.size()]);
    }

    private <T> Map<Number, T> _getPkValues(List<T> entities) {
        HashMap<Number, T> map = new HashMap<Number, T>();
        Number pkValue = null;
        for (T entity : entities) {
            pkValue = ReflectUtil.getPkValue(entity);
            map.put(pkValue, entity);
        }
        return map;
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    @Override
    public void setPrimaryCache(IPrimaryCache primaryCache) {
        this.primaryCache = primaryCache;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.primaryCache;
    }

    @Override
    public void setSecondCache(ISecondCache secondCache) {
        this.secondCache = secondCache;
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.secondCache;
    }

    @Override
    public void setTransactionManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.txManager;
    }
}

