/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.IGlobalMasterQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcMasterQueryImpl
extends AbstractJdbcQuery
implements IGlobalMasterQuery {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcMasterQueryImpl.class);

    @Override
    public <T> T findGlobalOneByQueryFromMaster(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        List<T> entities = this.findGlobalByQueryFromMaster(query, clusterName, clazz, useCache);
        if (entities.isEmpty()) {
            return null;
        }
        try {
            if (query.hasQueryFields()) {
                Object obj = ReflectUtil.cloneWithGivenField(entities.get(0), query.getFields());
                return (T)obj;
            }
            T obj = entities.get(0);
            return obj;
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public Number getGlobalCountFromMaster(String clusterName, Class<?> clazz, boolean useCache) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            long count = this.selectGlobalCountWithCache(dbResource, clusterName, clazz, useCache).longValue();
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public Number getGlobalCountFromMaster(IQuery query, String clusterName, Class<?> clazz) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            long count = this.selectGlobalCount(query, dbResource, clusterName, clazz).longValue();
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findGlobalByPkFromMaster(Number pk, String clusterName, Class<T> clazz) {
        return this.findGlobalByPkFromMaster(pk, clusterName, clazz, true);
    }

    @Override
    public <T> T findGlobalByPkFromMaster(Number pk, String clusterName, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            T t = this.selectByPkWithCache(dbResource, clusterName, pk, clazz, useCache);
            return t;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findGlobalByPksFromMaster(String clusterName, Class<T> clazz, Number ... pks) {
        return this.findGlobalByPksFromMaster(clusterName, clazz, true, pks);
    }

    @Override
    public <T> List<T> findGlobalByPksFromMaster(String clusterName, Class<T> clazz, boolean useCache, Number ... pks) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            List<T> list = this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pks, useCache);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findGlobalByPkListFromMaster(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            List<T> list = this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pks.toArray(new Number[pks.size()]), useCache);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    public List<Map<String, Object>> findGlobalBySqlFromMaster(SQL sql, String clusterName) {
        Object cur;
        IDBResource next = null;
        for (String tableName : sql.getTableNames()) {
            try {
                cur = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
            }
            catch (DBClusterException e) {
                throw new DBOperationException(e);
            }
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)next));
            }
            List<Map<String, Object>> result = this.selectGlobalBySql(next, sql);
            cur = result;
            return cur;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && next != null) {
                next.close();
            }
        }
    }

    @Override
    public <T> List<T> findGlobalByQueryFromMaster(IQuery query, String clusterName, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            List<T> result = null;
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.getGlobal(query, clusterName, tableName);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectGlobalPksByQuery(dbResource, query, clazz);
                    result = this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pkValues, useCache);
                } else {
                    result = this.selectGlobalByQuery(dbResource, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.putGlobal(query, clusterName, tableName, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                result = filteResult;
            }
            List<T> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }
}

