/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.SQL;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.IGlobalSlaveQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcSlaveQueryImpl
extends AbstractJdbcQuery
implements IGlobalSlaveQuery {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcSlaveQueryImpl.class);

    @Override
    public <T> T findGlobalOneByQueryFromSlave(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        List<T> entities = this.findGlobalByQueryFromSlave(query, clusterName, clazz, useCache, slave);
        if (entities.isEmpty()) {
            return null;
        }
        return entities.get(0);
    }

    @Override
    public Number getGlobalCountFromSlave(String clusterName, Class<?> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            long count = this.selectGlobalCountWithCache(dbResource, clusterName, clazz, useCache).longValue();
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public Number getGlobalCountFromSlave(IQuery query, String clusterName, Class<?> clazz, EnumDBMasterSlave slave) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            long count = this.selectGlobalCount(query, dbResource, clusterName, clazz).longValue();
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findGlobalByPkFromSlave(Number pk, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            T t = this.selectByPkWithCache(dbResource, clusterName, pk, clazz, useCache);
            return t;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findGlobalByPksFromSlave(String clusterName, Class<T> clazz, EnumDBMasterSlave slave, Number ... pks) {
        return this.findGlobalByPksFromSlave(clusterName, clazz, slave, true, pks);
    }

    @Override
    public <T> List<T> findGlobalByPksFromSlave(String clusterName, Class<T> clazz, EnumDBMasterSlave slave, boolean useCache, Number ... pks) {
        Transaction tx = null;
        ArrayList<T> result = new ArrayList<T>();
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            result.addAll(this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pks, useCache));
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return result;
    }

    @Override
    public <T> List<T> findGlobalByPkListFromSlave(List<? extends Number> pks, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        ArrayList<T> result = new ArrayList<T>();
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            result.addAll(this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pks.toArray(new Number[pks.size()]), useCache));
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> findGlobalBySqlFromSlave(SQL sql, String clusterName, EnumDBMasterSlave slave) {
        Object cur;
        IDBResource next = null;
        for (String tableName : sql.getTableNames()) {
            try {
                cur = this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, slave);
            }
            catch (DBClusterException e) {
                throw new DBOperationException(e);
            }
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)next));
            }
            List<Map<String, Object>> result = this.selectGlobalBySql(next, sql);
            cur = result;
            return cur;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && next != null) {
                next.close();
            }
        }
    }

    @Override
    public <T> List<T> findGlobalByQueryFromSlave(IQuery query, String clusterName, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, ReflectUtil.getClusterName(clazz), slave);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            }
            List<T> result = null;
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.getGlobal(query, clusterName, tableName);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectGlobalPksByQuery(dbResource, query, clazz);
                    result = this.selectGlobalByPksWithCache(dbResource, clusterName, clazz, pkValues, useCache);
                } else {
                    result = this.selectGlobalByQuery(dbResource, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.putGlobal(query, clusterName, tableName, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                }
                result = filteResult;
            }
            List<T> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }
}

