/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.IGlobalUpdate;
import org.pinus4j.datalayer.jdbc.AbstractJdbcUpdate;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IGlobalUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcUpdateImpl.class);

    @Override
    public Number globalSave(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>(1);
        entities.add(entity);
        return this.globalSaveBatch(entities, clusterName)[0];
    }

    @Override
    public Number[] globalSaveBatch(List<? extends Object> entities, String clusterName) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        int entitySize = entities.size();
        Number[] pks = new Number[entitySize];
        boolean isCheckPrimaryKey = true;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(entitySize);
        Number pk = null;
        Number maxPk = 0;
        Object entity = null;
        for (int i = 0; i < entitySize; ++i) {
            entity = entities.get(i);
            pk = ReflectUtil.getPkValue(entity);
            if (pk == null || pk.intValue() == 0) {
                map.put(i, entity);
                continue;
            }
            pks[i] = pk;
            maxPk = pk.intValue() > maxPk ? (Number)pk : (Number)maxPk;
        }
        if (!map.isEmpty()) {
            isCheckPrimaryKey = false;
            int[] newPks = this.idGenerator.genClusterUniqueIntIdBatch("/pinus/primarykey/" + clusterName, tableName, map.size(), ((Number)maxPk).longValue());
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                int pos = ((Number)entry.getKey()).intValue();
                try {
                    ReflectUtil.setPkValue(entities.get(pos), newPks[i]);
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
                pks[pos] = newPks[i];
                ++i;
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(((Number)maxPk).longValue(), clusterName, tableName);
        }
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            this._saveBatchGlobal(conn, entities);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCountGlobal(clusterName, tableName, entities.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e1) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e1);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return pks;
    }

    @Override
    public void globalUpdate(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.globalUpdateBatch(entities, clusterName);
    }

    @Override
    public void globalUpdateBatch(List<? extends Object> entities, String clusterName) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            this._updateBatchGlobal(conn, entities);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                ArrayList<Number> pks = new ArrayList<Number>(entities.size());
                for (Object object : entities) {
                    pks.add(ReflectUtil.getPkValue(object));
                }
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public void globalRemoveByPk(Number pk, Class<?> clazz, String clusterName) {
        ArrayList<Number> pks = new ArrayList<Number>(1);
        pks.add(pk);
        this.globalRemoveByPks(pks, clazz, clusterName);
    }

    @Override
    public void globalRemoveByPks(List<? extends Number> pks, Class<?> clazz, String clusterName) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, ReflectUtil.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            this._removeByPksGlobal(conn, pks, clazz);
            if (tx != null) {
                tx.enlistResource((XAResource)((Object)dbResource));
            } else {
                dbResource.commit();
            }
            String tableName = ReflectUtil.getTableName(clazz);
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
                this.primaryCache.decrCountGlobal(clusterName, tableName, pks.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private void _saveBatchGlobal(Connection conn, List<? extends Object> entities) {
        this._saveBatch(conn, entities, -1);
    }

    private void _updateBatchGlobal(Connection conn, List<? extends Object> entities) {
        this._updateBatch(conn, entities, -1);
    }

    private void _removeByPksGlobal(Connection conn, List<? extends Number> pks, Class<?> clazz) {
        this._removeByPks(conn, pks, clazz, -1);
    }
}

