/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.datalayer.IGlobalMasterQuery;
import org.pinus4j.datalayer.IGlobalSlaveQuery;
import org.pinus4j.datalayer.IGlobalUpdate;
import org.pinus4j.datalayer.IShardingMasterQuery;
import org.pinus4j.datalayer.IShardingSlaveQuery;
import org.pinus4j.datalayer.IShardingUpdate;
import org.pinus4j.datalayer.jdbc.GlobalJdbcMasterQueryImpl;
import org.pinus4j.datalayer.jdbc.GlobalJdbcSlaveQueryImpl;
import org.pinus4j.datalayer.jdbc.GlobalJdbcUpdateImpl;
import org.pinus4j.datalayer.jdbc.ShardingJdbcMasterQueryImpl;
import org.pinus4j.datalayer.jdbc.ShardingJdbcSlaveQueryImpl;
import org.pinus4j.datalayer.jdbc.ShardingJdbcUpdateImpl;
import org.pinus4j.generator.IIdGenerator;

public class JdbcDataLayerBuilder
implements IDataLayerBuilder {
    private IDBCluster dbCluster;
    private IPrimaryCache primaryCache;
    private ISecondCache secondCache;
    private static JdbcDataLayerBuilder instance;

    private JdbcDataLayerBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataLayerBuilder valueOf(IDBCluster dbCluster) {
        if (instance != null) return instance;
        Class<JdbcDataLayerBuilder> clazz = JdbcDataLayerBuilder.class;
        synchronized (JdbcDataLayerBuilder.class) {
            if (instance != null) return instance;
            instance = new JdbcDataLayerBuilder();
            instance.setDBCluster(dbCluster);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void setDBCluster(IDBCluster dbCluster) {
        if (dbCluster == null) {
            throw new IllegalArgumentException("input param should not be null");
        }
        this.dbCluster = dbCluster;
    }

    @Override
    public IDataLayerBuilder setPrimaryCache(IPrimaryCache primaryCache) {
        if (this.primaryCache != null) {
            this.primaryCache = primaryCache;
        }
        return this;
    }

    @Override
    public IDataLayerBuilder setSecondCache(ISecondCache secondCache) {
        if (this.secondCache != null) {
            this.secondCache = secondCache;
        }
        return this;
    }

    @Override
    public IGlobalUpdate buildGlobalUpdate(IIdGenerator idGenerator) {
        GlobalJdbcUpdateImpl globalUpdate = new GlobalJdbcUpdateImpl();
        globalUpdate.setTransactionManager(this.dbCluster.getTransactionManager());
        globalUpdate.setIdGenerator(idGenerator);
        globalUpdate.setDBCluster(this.dbCluster);
        globalUpdate.setPrimaryCache(this.primaryCache);
        globalUpdate.setSecondCache(this.secondCache);
        return globalUpdate;
    }

    @Override
    public IGlobalMasterQuery buildGlobalMasterQuery() {
        GlobalJdbcMasterQueryImpl globalMasterQuery = new GlobalJdbcMasterQueryImpl();
        globalMasterQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        globalMasterQuery.setDBCluster(this.dbCluster);
        globalMasterQuery.setPrimaryCache(this.primaryCache);
        globalMasterQuery.setSecondCache(this.secondCache);
        return globalMasterQuery;
    }

    @Override
    public IGlobalSlaveQuery buildGlobalSlaveQuery() {
        GlobalJdbcSlaveQueryImpl globalSlaveQuery = new GlobalJdbcSlaveQueryImpl();
        globalSlaveQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        globalSlaveQuery.setDBCluster(this.dbCluster);
        globalSlaveQuery.setPrimaryCache(this.primaryCache);
        globalSlaveQuery.setSecondCache(this.secondCache);
        return globalSlaveQuery;
    }

    @Override
    public IShardingUpdate buildShardingUpdate(IIdGenerator idGenerator) {
        ShardingJdbcUpdateImpl shardingUpdate = new ShardingJdbcUpdateImpl();
        shardingUpdate.setTransactionManager(this.dbCluster.getTransactionManager());
        shardingUpdate.setIdGenerator(idGenerator);
        shardingUpdate.setDBCluster(this.dbCluster);
        shardingUpdate.setPrimaryCache(this.primaryCache);
        shardingUpdate.setSecondCache(this.secondCache);
        return shardingUpdate;
    }

    @Override
    public IShardingMasterQuery buildShardingMasterQuery() {
        ShardingJdbcMasterQueryImpl shardingMasterQuery = new ShardingJdbcMasterQueryImpl();
        shardingMasterQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        shardingMasterQuery.setDBCluster(this.dbCluster);
        shardingMasterQuery.setPrimaryCache(this.primaryCache);
        shardingMasterQuery.setSecondCache(this.secondCache);
        return shardingMasterQuery;
    }

    @Override
    public IShardingSlaveQuery buildShardingSlaveQuery() {
        ShardingJdbcSlaveQueryImpl shardingSlaveQuery = new ShardingJdbcSlaveQueryImpl();
        shardingSlaveQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        shardingSlaveQuery.setDBCluster(this.dbCluster);
        shardingSlaveQuery.setPrimaryCache(this.primaryCache);
        shardingSlaveQuery.setSecondCache(this.secondCache);
        return shardingSlaveQuery;
    }
}

