/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.IShardingMasterQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcMasterQueryImpl
extends AbstractJdbcQuery
implements IShardingMasterQuery {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcMasterQueryImpl.class);

    @Override
    public Number getCountFromMaster(Class<?> clazz, boolean useCache) {
        Long l;
        block12: {
            Transaction tx = null;
            List<IDBResource> dbResources = null;
            try {
                tx = this.txManager.getTransaction();
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                long count = 0L;
                for (IDBResource dbResource : dbResources) {
                    if (tx != null) {
                        tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                    }
                    count += this.selectCountWithCache((ShardingDBResource)dbResource, clazz, useCache).longValue();
                }
                l = count;
                if (tx != null || dbResources == null) break block12;
            }
            catch (Exception e) {
                try {
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (Exception e1) {
                            throw new DBOperationException(e1);
                        }
                    }
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    if (tx == null && dbResources != null) {
                        for (IDBResource dbResource : dbResources) {
                            dbResource.close();
                        }
                    }
                    throw throwable;
                }
            }
            for (IDBResource dbResource : dbResources) {
                dbResource.close();
            }
        }
        return l;
    }

    @Override
    public Number getCountFromMaster(Class<?> clazz, IQuery query) {
        Long l;
        block12: {
            Transaction tx = null;
            List<IDBResource> dbResources = null;
            try {
                tx = this.txManager.getTransaction();
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                long count = 0L;
                for (IDBResource dbResource : dbResources) {
                    if (tx != null) {
                        tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                    }
                    count += this.selectCount((ShardingDBResource)dbResource, clazz, query).longValue();
                }
                l = count;
                if (tx != null || dbResources == null) break block12;
            }
            catch (Exception e) {
                try {
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (Exception e1) {
                            throw new DBOperationException(e1);
                        }
                    }
                    throw new DBOperationException(e);
                }
                catch (Throwable throwable) {
                    if (tx == null && dbResources != null) {
                        for (IDBResource dbResource : dbResources) {
                            dbResource.close();
                        }
                    }
                    throw throwable;
                }
            }
            for (IDBResource dbResource : dbResources) {
                dbResource.close();
            }
        }
        return l;
    }

    @Override
    public Number getCountFromMaster(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            Number count;
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            Number number = count = this.selectCountWithCache(dbResource, clazz, useCache);
            return number;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public Number getCountFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<?> clazz) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            Number number = this.selectCount(dbResource, clazz, query);
            return number;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findByPkFromMaster(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            T t = this.selectByPkWithCache(dbResource, pk, clazz, useCache);
            return t;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findOneByQueryFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        List<T> entities = this.findByQueryFromMaster(query, shardingKey, clazz, useCache);
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() > 1) {
            throw new DBOperationException("\u67e5\u8be2\u7ed3\u679c\u5927\u4e8e1\u6761\u8bb0\u5f55");
        }
        try {
            if (query.hasQueryFields()) {
                Object obj = ReflectUtil.cloneWithGivenField(entities.get(0), query.getFields());
                return (T)obj;
            }
            T obj = entities.get(0);
            return obj;
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> List<T> findByPksFromMaster(IShardingKey<?> shardingKey, Class<T> clazz, Number ... pks) {
        return this.findByPksFromMaster(shardingKey, clazz, true, pks);
    }

    @Override
    public <T> List<T> findByPksFromMaster(IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, Number ... pks) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> list = this.selectByPksWithCache(dbResource, clazz, pks, useCache);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findByPkListFromMaster(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> list = this.selectByPksWithCache(dbResource, clazz, pks.toArray(new Number[pks.size()]), useCache);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public List<Map<String, Object>> findBySqlFromMaster(SQL sql, IShardingKey<?> shardingKey) {
        Object cur;
        ShardingDBResource next = null;
        for (String tableName : sql.getTableNames()) {
            cur = this._getDbFromMaster(tableName, shardingKey);
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)next);
            }
            List<Map<String, Object>> result = this.selectBySql(next, sql);
            cur = result;
            return cur;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && next != null) {
                next.close();
            }
        }
    }

    @Override
    public <T> List<T> findByQueryFromMaster(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> result = null;
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.get(query, dbResource);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectPksByQuery(dbResource, query, clazz);
                    result = this.selectByPksWithCache(dbResource, clazz, pkValues, useCache);
                } else {
                    result = this.selectByQuery(dbResource, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.put(query, dbResource, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    try {
                        filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                    }
                    catch (Exception e) {
                        throw new DBOperationException(e);
                    }
                }
                result = filteResult;
            }
            List<T> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private ShardingDBResource _getDbFromMaster(Class<?> clazz, IShardingKey<?> shardingKey) {
        String tableName = ReflectUtil.getTableName(clazz);
        return this._getDbFromMaster(tableName, shardingKey);
    }

    private ShardingDBResource _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return shardingDBResource;
    }
}

