/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.api.SQL;
import org.pinus4j.api.enums.EnumDBMasterSlave;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.IShardingSlaveQuery;
import org.pinus4j.datalayer.jdbc.AbstractJdbcQuery;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcSlaveQueryImpl
extends AbstractJdbcQuery
implements IShardingSlaveQuery {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcSlaveQueryImpl.class);

    @Override
    public Number getCountFromSlave(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromSlave(clazz, shardingKey, slave);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            Number number = this.selectCountWithCache(dbResource, clazz, useCache);
            return number;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findByPkFromSlave(Number pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromSlave(clazz, shardingKey, slave);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            T t = this.selectByPkWithCache(dbResource, pk, clazz, useCache);
            return t;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findOneByQueryFromSlave(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        List<T> entities = this.findByQueryFromSlave(query, shardingKey, clazz, useCache, slave);
        if (entities.isEmpty()) {
            return null;
        }
        return entities.get(0);
    }

    @Override
    public <T> List<T> findByPksFromSlave(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave slave, Number ... pks) {
        return this.findByPksFromSlave(shardingKey, clazz, slave, true, pks);
    }

    @Override
    public <T> List<T> findByPksFromSlave(IShardingKey<?> shardingKey, Class<T> clazz, EnumDBMasterSlave slave, boolean useCache, Number ... pks) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromSlave(clazz, shardingKey, slave);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> list = this.selectByPksWithCache(dbResource, clazz, pks, true);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findByPkListFromSlave(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromSlave(clazz, shardingKey, slave);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> list = this.selectByPksWithCache(dbResource, clazz, pks.toArray(new Number[pks.size()]), useCache);
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public List<Map<String, Object>> findBySqlFromSlave(SQL sql, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        Object cur;
        ShardingDBResource next = null;
        for (String tableName : sql.getTableNames()) {
            cur = this._getDbFromSlave(tableName, shardingKey, slave);
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
            List<Map<String, Object>> result = this.selectBySql(next, sql);
            if (tx != null) {
                tx.enlistResource((XAResource)next);
            }
            cur = result;
            return cur;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && next != null) {
                next.close();
            }
        }
    }

    @Override
    public <T> List<T> findByQueryFromSlave(IQuery query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave slave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromSlave(clazz, shardingKey, slave);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            List<T> result = null;
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                result = this.secondCache.get(query, dbResource);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    Number[] pkValues = this.selectPksByQuery(dbResource, query, clazz);
                    result = this.selectByPksWithCache(dbResource, clazz, pkValues, useCache);
                } else {
                    result = this.selectByQuery(dbResource, query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    this.secondCache.put(query, dbResource, result);
                }
            }
            ArrayList<T> filteResult = new ArrayList<T>(result.size());
            if (query.hasQueryFields()) {
                for (Object obj : result) {
                    try {
                        filteResult.add(ReflectUtil.cloneWithGivenField(obj, query.getFields()));
                    }
                    catch (Exception e) {
                        throw new DBOperationException(e);
                    }
                }
                result = filteResult;
            }
            List<T> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private ShardingDBResource _getDbFromSlave(Class<?> clazz, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        String tableName = ReflectUtil.getTableName(clazz);
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromSlave(tableName, shardingKey, slave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return shardingDBResource;
    }

    private ShardingDBResource _getDbFromSlave(String tableName, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromSlave(tableName, shardingKey, slave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return shardingDBResource;
    }
}

