/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.IShardingKey;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.IShardingUpdate;
import org.pinus4j.datalayer.jdbc.AbstractJdbcUpdate;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IShardingUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcUpdateImpl.class);

    public Number save(Object entity, IShardingKey shardingKey) {
        Class<?> clazz = entity.getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        boolean isCheckPrimaryKey = true;
        Number pk = ReflectUtil.getPkValue(entity);
        if (pk == null || pk.intValue() == 0) {
            isCheckPrimaryKey = false;
            pk = this.idGenerator.genClusterUniqueLongId("/pinus/primarykey/" + shardingKey.getClusterName(), tableName);
            try {
                ReflectUtil.setPkValue(entity, pk);
            }
            catch (Exception e) {
                throw new DBOperationException(e);
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(pk.longValue(), shardingKey.getClusterName(), tableName);
        }
        ArrayList<Object> entities = new ArrayList<Object>(1);
        entities.add(entity);
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(tableName, shardingKey);
            Connection conn = dbResource.getConnection();
            this._saveBatch(conn, entities, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCount(dbResource, 1L);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return pk;
    }

    @Override
    public Number[] saveBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = ReflectUtil.getTableName(clazz);
        int entitySize = entities.size();
        Number[] pks = new Number[entitySize];
        boolean isCheckPrimaryKey = true;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(entitySize);
        Number pk = null;
        Number maxPk = 0;
        Object entity = null;
        for (int i = 0; i < entitySize; ++i) {
            entity = entities.get(i);
            pk = ReflectUtil.getPkValue(entity);
            if (pk == null || pk.longValue() == 0L) {
                map.put(i, entity);
                continue;
            }
            pks[i] = pk;
            maxPk = pk.intValue() > maxPk ? (Number)pk : (Number)maxPk;
        }
        if (!map.isEmpty()) {
            isCheckPrimaryKey = false;
            int[] newPks = this.idGenerator.genClusterUniqueIntIdBatch("/pinus/primarykey/" + shardingKey.getClusterName(), tableName, map.size(), ((Number)maxPk).longValue());
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                int pos = ((Number)entry.getKey()).intValue();
                try {
                    ReflectUtil.setPkValue(entities.get(pos), newPks[i]);
                }
                catch (Exception e) {
                    throw new DBOperationException(e);
                }
                pks[pos] = newPks[i];
                ++i;
            }
        }
        if (isCheckPrimaryKey) {
            this.idGenerator.checkAndSetPrimaryKey(((Number)maxPk).longValue(), shardingKey.getClusterName(), tableName);
        }
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(tableName, shardingKey);
            Connection conn = dbResource.getConnection();
            this._saveBatch(conn, entities, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.incrCount(dbResource, pks.length);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return pks;
    }

    @Override
    public void update(Object entity, IShardingKey<?> shardingKey) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.updateBatch(entities, shardingKey);
    }

    @Override
    public void updateBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        Class<?> clazz = entities.get(0).getClass();
        String talbeName = ReflectUtil.getTableName(clazz);
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(talbeName, shardingKey);
            Connection conn = dbResource.getConnection();
            this._updateBatch(conn, entities, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                ArrayList<Number> pks = new ArrayList<Number>(entities.size());
                for (Object object : entities) {
                    pks.add(ReflectUtil.getPkValue(object));
                }
                this.primaryCache.remove(dbResource, pks);
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public void removeByPk(Number pk, IShardingKey<?> shardingKey, Class<?> clazz) {
        ArrayList<Number> pks = new ArrayList<Number>(1);
        pks.add(pk);
        this.removeByPks(pks, shardingKey, clazz);
    }

    @Override
    public void removeByPks(List<? extends Number> pks, IShardingKey<?> shardingKey, Class<?> clazz) {
        String talbeName = ReflectUtil.getTableName(clazz);
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(talbeName, shardingKey);
            Connection conn = dbResource.getConnection();
            this._removeByPks(conn, pks, clazz, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.remove(dbResource, pks);
                this.primaryCache.decrCount(dbResource, pks.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            } else if (dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private ShardingDBResource _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException(e);
        }
        return shardingDBResource;
    }
}

