/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.generator.AbstractDBGenerator;
import org.pinus4j.generator.IIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSequenceIdGenerator
implements IIdGenerator {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDBGenerator.class);
    private final Map<String, Queue<Long>> longIdBuffer = new HashMap<String, Queue<Long>>();
    private int BUFFER_SIZE;
    private ZooKeeper zk;

    public AbstractSequenceIdGenerator(CuratorFramework curatorClient, int bufferSize) {
        this.BUFFER_SIZE = bufferSize;
        try {
            this.zk = curatorClient.getZookeeperClient().getZooKeeper();
            Stat stat = this.zk.exists("/pinus/primarykey", false);
            if (stat == null) {
                this.zk.create("/pinus/primarykey", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getBufferKey(String clusterName, String name) {
        return clusterName + name;
    }

    @Override
    public void checkAndSetPrimaryKey(long pk, String clusterName, String name) {
        Lock lock = this.getLock(clusterName + name);
        try {
            lock.lock();
            String pkNode = "/pinus/primarykey/" + clusterName + "/" + name;
            Stat stat = this.zk.exists(pkNode, false);
            if (stat == null) {
                this.zk.create(pkNode, String.valueOf(pk).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                byte[] data = this.zk.getData(pkNode, false, null);
                long currentPk = Long.parseLong(new String(data));
                if (pk > currentPk) {
                    this.zk.setData(pkNode, String.valueOf(pk).getBytes(), -1);
                }
            }
        }
        catch (Exception e) {
            throw new DBOperationException("\u6821\u9a8c\u4e3b\u952e\u503c\u5931\u8d25");
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int genClusterUniqueIntId(String clusterName, String name) {
        return this.genClusterUniqueIntId(clusterName, name, 0L);
    }

    @Override
    public int genClusterUniqueIntId(String clusterName, String name, long seed) {
        long id = this._genId(clusterName, name, seed);
        if (id == 0L) {
            int retry = 5;
            while (retry-- == 0 && (id = this._genId(clusterName, name, seed)) <= 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("\u751f\u6210id=0, \u91cd\u65b0\u751f\u6210");
                }
            }
        }
        if (id == 0L) {
            throw new RuntimeException("\u751f\u6210id\u5931\u8d25");
        }
        return new Long(id).intValue();
    }

    @Override
    public long genClusterUniqueLongId(String clusterName, String name) {
        return this.genClusterUniqueLongId(clusterName, name, 0L);
    }

    @Override
    public long genClusterUniqueLongId(String clusterName, String name, long seed) {
        long id = this._genId(clusterName, name, seed);
        if (id == 0L) {
            int retry = 5;
            while (retry-- == 0 && (id = this._genId(clusterName, name, seed)) <= 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("\u751f\u6210id=0, \u91cd\u65b0\u751f\u6210");
                }
            }
        }
        if (id == 0L) {
            throw new RuntimeException("\u751f\u6210id\u5931\u8d25");
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _genId(String clusterName, String name, long seed) {
        Queue<Long> buffer = null;
        Map<String, Queue<Long>> map = this.longIdBuffer;
        synchronized (map) {
            buffer = this.longIdBuffer.get(this.getBufferKey(clusterName, name));
            if (buffer != null && !buffer.isEmpty()) {
                long id = buffer.poll();
                return id;
            }
            if (buffer == null || buffer.isEmpty()) {
                long[] newIds;
                buffer = new ConcurrentLinkedQueue<Long>();
                for (long newId : newIds = this._genClusterUniqueLongIdBatch(clusterName, name, this.BUFFER_SIZE, seed)) {
                    buffer.offer(newId);
                }
                this.longIdBuffer.put(this.getBufferKey(clusterName, name), buffer);
            }
        }
        Long id = buffer.poll();
        if (id == 0L) {
            throw new RuntimeException("\u751f\u6210id\u5931\u8d25");
        }
        return id;
    }

    @Override
    public int[] genClusterUniqueIntIdBatch(String clusterName, String name, int batchSize) {
        int[] intIds = this._genClusterUniqueIntIdBatch(clusterName, name, batchSize, 0L);
        return intIds;
    }

    @Override
    public int[] genClusterUniqueIntIdBatch(String clusterName, String name, int batchSize, long seed) {
        int[] intIds = this._genClusterUniqueIntIdBatch(clusterName, name, batchSize, seed);
        return intIds;
    }

    @Override
    public long[] genClusterUniqueLongIdBatch(String clusterName, String name, int batchSize) {
        long[] longIds = this._genClusterUniqueLongIdBatch(clusterName, name, batchSize, 0L);
        return longIds;
    }

    @Override
    public long[] genClusterUniqueLongIdBatch(String clusterName, String name, int batchSize, long seed) {
        long[] longIds = this._genClusterUniqueLongIdBatch(clusterName, name, batchSize, seed);
        return longIds;
    }

    private int[] _genClusterUniqueIntIdBatch(String clusterName, String name, int batchSize, long seed) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, batchSize\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        Lock lock = this.getLock(name);
        int[] ids = new int[batchSize];
        try {
            lock.lock();
            String clusterNode = clusterName;
            Stat stat = this.zk.exists(clusterNode, false);
            if (stat == null) {
                this.zk.create(clusterNode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            long pk = 0L;
            long nodeValue = seed;
            String pkNode = clusterNode + "/" + name;
            stat = this.zk.exists(pkNode, false);
            if (stat == null) {
                this.zk.create(pkNode, String.valueOf(nodeValue + (long)batchSize).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                pk = Long.parseLong(new String(this.zk.getData(pkNode, false, null)));
                if (pk > nodeValue) {
                    nodeValue = pk;
                }
            }
            for (int i = 1; i <= batchSize; ++i) {
                ids[i - 1] = (int)(nodeValue + (long)i);
            }
            this.zk.setData(pkNode, String.valueOf(nodeValue += (long)batchSize).getBytes(), -1);
        }
        catch (Exception e) {
            throw new DBOperationException("\u751f\u6210\u552f\u4e00id\u5931\u8d25", e);
        }
        finally {
            lock.unlock();
        }
        return ids;
    }

    private long[] _genClusterUniqueLongIdBatch(String clusterName, String name, int batchSize, long seed) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, batchSize\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        Lock lock = this.getLock(name);
        long[] ids = new long[batchSize];
        try {
            lock.lock();
            String clusterNode = clusterName;
            Stat stat = this.zk.exists(clusterNode, false);
            if (stat == null) {
                this.zk.create(clusterNode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            long pk = 0L;
            long nodeValue = seed;
            String pkNode = clusterNode + "/" + name;
            stat = this.zk.exists(pkNode, false);
            if (stat == null) {
                this.zk.create(pkNode, String.valueOf(nodeValue + (long)batchSize).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                pk = Long.parseLong(new String(this.zk.getData(pkNode, false, null)));
                if (pk > nodeValue) {
                    nodeValue = pk;
                }
            }
            for (int i = 1; i <= batchSize; ++i) {
                ids[i - 1] = nodeValue + (long)i;
            }
            this.zk.setData(pkNode, String.valueOf(nodeValue += (long)batchSize).getBytes(), -1);
        }
        catch (Exception e) {
            throw new DBOperationException("\u751f\u6210\u552f\u4e00id\u5931\u8d25", e);
        }
        finally {
            lock.unlock();
        }
        return ids;
    }

    public abstract Lock getLock(String var1);
}

