/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pinus4j.generator.beans.DBIndex;
import org.pinus4j.generator.beans.DBTableColumn;
import org.pinus4j.generator.beans.DataTypeBind;
import org.pinus4j.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger LOG = LoggerFactory.getLogger(DBTable.class);
    private String cluster;
    private String name;
    private int tableIndex = -1;
    private String shardingBy;
    private int shardingNum;
    private List<DBTableColumn> columns = new ArrayList<DBTableColumn>();
    private List<DBIndex> indexes = new ArrayList<DBIndex>();

    public DBTable(String name) {
        this.name = name;
    }

    public String getNameWithIndex() {
        if (this.tableIndex > -1) {
            return this.name + this.tableIndex;
        }
        return this.name;
    }

    public void addColumn(DBTableColumn column) {
        this.columns.add(column);
    }

    public void addIndex(DBIndex index) {
        this.indexes.add(index);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DBTableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DBTableColumn> columns) {
        this.columns = columns;
    }

    public Map<String, DBTableColumn> getColumnMap() {
        HashMap<String, DBTableColumn> columnMap = new HashMap<String, DBTableColumn>(this.columns.size());
        for (DBTableColumn column : this.columns) {
            columnMap.put(column.getField(), column);
        }
        return columnMap;
    }

    public Map<String, DBIndex> getIndexMap() {
        HashMap<String, DBIndex> indexMap = new HashMap<String, DBIndex>(this.indexes.size());
        for (DBIndex index : this.indexes) {
            indexMap.put(index.getIndexName(), index);
        }
        return indexMap;
    }

    public String[] getCreateSQL() {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        String primaryKey = null;
        sql.append("CREATE TABLE " + this.getNameWithIndex()).append("(");
        for (DBTableColumn column : this.columns) {
            if (column.isPrimaryKey()) {
                primaryKey = column.getField();
            }
            sql.append(this._sqlFieldPhrase(column)).append(",");
        }
        sql.append(" PRIMARY KEY(" + primaryKey + ")");
        sql.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8;");
        sqls.add(sql.toString());
        for (DBIndex dbIndex : this.indexes) {
            sql.setLength(0);
            sql.append(this._sqlCreateIndex(dbIndex));
            sqls.add(sql.toString());
        }
        return sqls.toArray(new String[sqls.size()]);
    }

    public String[] getAlterSQL(DBTable existTable, boolean isDelete) {
        if (!existTable.getNameWithIndex().equals(this.getNameWithIndex())) {
            return new String[0];
        }
        ArrayList<String> sqls = new ArrayList<String>();
        Map<String, DBTableColumn> dbColumnMap = existTable.getColumnMap();
        DBTableColumn dbColumn = null;
        for (DBTableColumn entityColumn : this.columns) {
            dbColumn = dbColumnMap.get(entityColumn.getField());
            if (dbColumn != null) {
                dbColumnMap.remove(entityColumn.getField());
            }
            if (dbColumn == null) {
                String addSql = "ALTER TABLE " + this.getNameWithIndex() + " ADD COLUMN " + this._sqlFieldPhrase(entityColumn) + ";";
                sqls.add(addSql);
                continue;
            }
            if (entityColumn.equals(dbColumn)) continue;
            String modifySql = "ALTER TABLE " + this.getNameWithIndex() + " MODIFY " + this._sqlFieldPhrase(entityColumn) + ";";
            sqls.add(modifySql);
        }
        Map<String, DBIndex> dbIndexMap = existTable.getIndexMap();
        DBIndex dbIndex = null;
        for (DBIndex entityIndex : this.indexes) {
            dbIndex = dbIndexMap.get(entityIndex.getIndexName());
            if (dbIndex != null) {
                dbIndexMap.remove(entityIndex.getIndexName());
            }
            if (dbIndex == null) {
                sqls.add(this._sqlCreateIndex(entityIndex));
                continue;
            }
            if (entityIndex.equals(dbIndex)) continue;
            sqls.add("DROP INDEX " + dbIndex.getIndexName() + " ON " + this.getNameWithIndex());
            sqls.add(this._sqlCreateIndex(entityIndex));
        }
        if (isDelete) {
            for (String field : dbColumnMap.keySet()) {
                sqls.add("ALTER TABLE " + this.getNameWithIndex() + " DROP COLUMN " + field + ";");
            }
            for (DBIndex index : dbIndexMap.values()) {
                sqls.add("DROP INDEX " + index.getIndexName() + " ON " + this.getNameWithIndex());
            }
        }
        return sqls.toArray(new String[sqls.size()]);
    }

    private String _sqlCreateIndex(DBIndex index) {
        StringBuilder indexSql = new StringBuilder();
        if (index.isUnique()) {
            indexSql.append("CREATE UNIQUE INDEX");
        } else {
            indexSql.append("CREATE INDEX");
        }
        if (StringUtils.isBlank(index.getField())) {
            throw new IllegalArgumentException("\u7d22\u5f15\u6ce8\u89e3\u683c\u5f0f\u9519\u8bef\uff0cfield\u4e0d\u80fd\u4e3a\u7a7a");
        }
        indexSql.append(" ").append(index.getIndexName()).append(" ON").append(" ").append(this.getNameWithIndex());
        indexSql.append("(").append(index.getField()).append(");");
        return indexSql.toString();
    }

    private String _sqlFieldPhrase(DBTableColumn column) {
        StringBuilder pharse = new StringBuilder();
        pharse.append(column.getField()).append(" ");
        switch (DataTypeBind.getEnum(column.getType())) {
            case UPDATETIME: {
                pharse.append("timestamp");
                pharse.append(" NOT NULL");
                pharse.append(" DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
                break;
            }
            case DATETIME: {
                pharse.append("datetime");
                if (!column.isCanNull()) {
                    pharse.append(" NOT NULL");
                }
                if (!column.isHasDefault()) break;
                pharse.append(" DEFAULT " + column.getDefaultValue());
                break;
            }
            default: {
                pharse.append(column.getType());
                if (column.getLength() > 0) {
                    pharse.append("(" + column.getLength() + ")");
                }
                if (!column.isCanNull()) {
                    pharse.append(" NOT NULL");
                }
                if (column.isAutoIncrement() && this.shardingNum > 0) {
                    pharse.append(" AUTO_INCREMENT");
                }
                if (column.getDefaultValue() == null) break;
                pharse.append(" DEFAULT " + column.getDefaultValue());
            }
        }
        pharse.append(" COMMENT '").append(column.getComment()).append("'");
        return pharse.toString();
    }

    public String toString() {
        return "DBTable [cluster=" + this.cluster + ", name=" + this.name + ", tableIndex=" + this.tableIndex + ", shardingBy=" + this.shardingBy + ", shardingNum=" + this.shardingNum + ", columns=" + this.columns + ", indexes=" + this.indexes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.shardingBy == null ? 0 : this.shardingBy.hashCode());
        result = 31 * result + this.shardingNum;
        result = 31 * result + this.tableIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBTable other = (DBTable)obj;
        if (this.cluster == null ? other.cluster != null : !this.cluster.equals(other.cluster)) {
            return false;
        }
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.shardingBy == null ? other.shardingBy != null : !this.shardingBy.equals(other.shardingBy)) {
            return false;
        }
        if (this.shardingNum != other.shardingNum) {
            return false;
        }
        return this.tableIndex == other.tableIndex;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }

    public int getShardingNum() {
        return this.shardingNum;
    }

    public void setShardingNum(int shardingNum) {
        this.shardingNum = shardingNum;
    }

    public String getShardingBy() {
        return this.shardingBy;
    }

    public void setShardingBy(String shardingBy) {
        this.shardingBy = shardingBy;
    }
}

