/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.generator.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.pinus4j.api.enums.EnumSyncAction;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.exceptions.DDLException;
import org.pinus4j.generator.AbstractDBGenerator;
import org.pinus4j.generator.beans.DBIndex;
import org.pinus4j.generator.beans.DBTable;
import org.pinus4j.generator.beans.DBTableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMySqlGeneratorImpl
extends AbstractDBGenerator {
    public static final Logger LOG = LoggerFactory.getLogger(DBMySqlGeneratorImpl.class);
    public static final String SQL_SHOWTABLE = "show tables";
    private static final Map<String, Map<String, DBTable>> existsTable = new HashMap<String, Map<String, DBTable>>();
    private EnumSyncAction syncAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncTable(Connection conn, DBTable table) throws DDLException {
        block16: {
            Map<String, DBTable> tables = this._getTable(conn);
            DBTable existTable = tables.get(table.getNameWithIndex());
            if (existTable != null) {
                if (this.syncAction == EnumSyncAction.UPDATE) {
                    existTable.setCluster(table.getCluster());
                    existTable.setName(table.getName());
                    existTable.setTableIndex(table.getTableIndex());
                    existTable.setShardingBy(table.getShardingBy());
                    existTable.setShardingNum(table.getShardingNum());
                    try {
                        Statement s = null;
                        for (String sql : table.getAlterSQL(existTable, false)) {
                            try {
                                s = conn.createStatement();
                                LOG.info("begin execute [" + sql + "]");
                                s.execute(sql);
                            }
                            finally {
                                if (s != null) {
                                    s.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new DDLException("update table =" + table.getName() + " failure", e);
                    }
                }
                return;
            }
            try {
                Statement s = null;
                for (String sql : table.getCreateSQL()) {
                    try {
                        s = conn.createStatement();
                        LOG.info(sql);
                        s.execute(sql);
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                String ignore = "Table '" + table.getNameWithIndex() + "' already exists";
                if (e.getMessage().equals(ignore)) break block16;
                throw new DDLException("create table =" + table.getName() + " failure", e);
            }
        }
    }

    @Override
    public void syncTable(Connection conn, DBTable table, int num) throws DDLException {
        if (num <= 0) {
            LOG.warn("\u751f\u6210\u8868\u7684\u6570\u91cf\u4e3a0, \u5ffd\u7565\u751f\u6210\u6570\u636e\u8868, \u8bf7\u68c0\u67e5\u96f6\u5e93\u7684shard_cluster\u8868\u7684\u914d\u7f6e");
            return;
        }
        for (int i = 0; i < num; ++i) {
            table.setTableIndex(i);
            this.syncTable(conn, table);
        }
    }

    private Map<String, DBTable> _getTable(Connection conn) throws DDLException {
        String url = null;
        try {
            url = conn.getMetaData().getURL();
        }
        catch (SQLException e1) {
            throw new DDLException(e1);
        }
        if (existsTable.containsKey(url)) {
            return existsTable.get(url);
        }
        HashMap<String, DBTable> tables = new HashMap<String, DBTable>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(SQL_SHOWTABLE);
            rs = ps.executeQuery();
            DBTable table = null;
            while (rs.next()) {
                String tableName = rs.getString(1);
                table = new DBTable(tableName);
                this._initTableColumn(table, conn);
                this._initTableIndex(table, conn);
                tables.put(tableName, table);
            }
            existsTable.put(url, tables);
        }
        catch (SQLException e) {
            try {
                throw new DDLException(e);
            }
            catch (Throwable throwable) {
                SQLBuilder.close(ps, rs);
                throw throwable;
            }
        }
        SQLBuilder.close(ps, rs);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initTableIndex(DBTable table, Connection dbconn) throws SQLException {
        ResultSet indexRs = null;
        Statement s = dbconn.createStatement();
        try {
            indexRs = s.executeQuery("SHOW INDEX FROM " + table.getName());
            HashMap<String, String> map = new HashMap<String, String>();
            while (indexRs.next()) {
                String keyName = indexRs.getString("Key_name");
                if (keyName.equals("PRIMARY")) continue;
                String colName = indexRs.getString("Column_name");
                boolean isUniqe = indexRs.getInt("Non_unique") == 0;
                String fieldInfo = colName + ":" + isUniqe;
                if (map.get(keyName) != null) {
                    map.put(keyName, (String)map.get(keyName) + "^" + fieldInfo);
                    continue;
                }
                map.put(keyName, fieldInfo);
            }
            DBIndex index = null;
            StringBuilder field = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                String[] fieldInfos;
                index = new DBIndex();
                for (String fieldInfo : fieldInfos = ((String)entry.getValue()).split("\\^")) {
                    String[] ss = fieldInfo.split(":");
                    field.append(ss[0]).append(",");
                    index.setUnique(Boolean.valueOf(ss[1]));
                }
                field.deleteCharAt(field.length() - 1);
                index.setField(field.toString());
                field.setLength(0);
                table.addIndex(index);
            }
        }
        finally {
            if (indexRs != null) {
                indexRs.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initTableColumn(DBTable table, Connection dbconn) throws SQLException {
        DBTableColumn column = null;
        ResultSet colRs = null;
        Statement s = dbconn.createStatement();
        try {
            colRs = s.executeQuery("show full fields from " + table.getName());
            while (colRs.next()) {
                column = new DBTableColumn();
                column.setField(colRs.getString(1));
                String type = colRs.getString(2);
                if (type.indexOf("(") > 0) {
                    column.setType(type.substring(0, type.indexOf("(")));
                    column.setLength(Integer.parseInt(type.subSequence(type.indexOf("(") + 1, type.indexOf(")")).toString()));
                } else {
                    column.setType(type);
                }
                if (colRs.getString(4).equals("NO")) {
                    column.setCanNull(false);
                } else {
                    column.setCanNull(true);
                }
                if (colRs.getString(5).equals("PRI")) {
                    column.setPrimaryKey(true);
                }
                if (colRs.getObject(6) != null) {
                    column.setDefaultValue(colRs.getObject(6));
                    column.setHasDefault(true);
                } else {
                    column.setHasDefault(false);
                }
                String extra = colRs.getString(7);
                if (extra.equals("auto_increment")) {
                    column.setAutoIncrement(true);
                } else if (extra.equals("on update CURRENT_TIMESTAMP")) {
                    column.setType("updatetime");
                }
                column.setComment(colRs.getString(9));
                table.addColumn(column);
            }
        }
        catch (SQLException e) {
            LOG.warn("get column of " + table.getName() + " fail", (Throwable)e);
        }
        finally {
            if (colRs != null) {
                colRs.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    public EnumSyncAction getSyncAction() {
        return this.syncAction;
    }

    @Override
    public void setSyncAction(EnumSyncAction syncAction) {
        this.syncAction = syncAction;
    }
}

