/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.transaction.impl;

import java.util.function.Supplier;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;
import org.pinus4j.transaction.impl.LocalTransaction;

public class BestEffortsOnePCJtaTransactionManager
implements TransactionManager {
    private static final TransactionManager instance = new BestEffortsOnePCJtaTransactionManager();
    private static final ThreadLocal<EnumTransactionIsolationLevel> txLevelLocal = ThreadLocal.withInitial(new Supplier<EnumTransactionIsolationLevel>(){

        @Override
        public EnumTransactionIsolationLevel get() {
            return EnumTransactionIsolationLevel.READ_COMMITTED;
        }
    });
    private static final ThreadLocal<Transaction> txLocal = new ThreadLocal();

    public static TransactionManager getInstance() {
        return instance;
    }

    public void setTransactionIsolationLevel(EnumTransactionIsolationLevel txLevel) {
        txLevelLocal.set(txLevel);
    }

    public EnumTransactionIsolationLevel getTransactionIsolationLevel() {
        return txLevelLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws NotSupportedException, SystemException {
        Transaction tx = txLocal.get();
        if (tx == null) {
            BestEffortsOnePCJtaTransactionManager bestEffortsOnePCJtaTransactionManager = this;
            synchronized (bestEffortsOnePCJtaTransactionManager) {
                if (tx == null) {
                    tx = new LocalTransaction();
                    ((LocalTransaction)tx).setIsolationLevel(this.getTransactionIsolationLevel());
                    txLocal.set(tx);
                }
            }
        }
        txLocal.set(tx);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            txLocal.get().commit();
        }
        finally {
            txLocal.remove();
        }
    }

    public int getStatus() throws SystemException {
        if (txLocal.get() != null) {
            return txLocal.get().getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        return txLocal.get();
    }

    public void resume(Transaction arg0) throws InvalidTransactionException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            txLocal.get().rollback();
        }
        finally {
            txLocal.remove();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        txLocal.get().setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend() throws SystemException {
        throw new UnsupportedOperationException();
    }
}

