/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.transaction.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.IResourceId;
import org.pinus4j.transaction.ITransaction;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;

public class LocalTransaction
implements ITransaction {
    private Map<IResourceId, IDBResource> txRes = new LinkedHashMap<IResourceId, IDBResource>();
    private EnumTransactionIsolationLevel txLevel;
    private AtomicInteger status = new AtomicInteger(0);

    @Override
    public void setIsolationLevel(EnumTransactionIsolationLevel txLevel) {
        this.txLevel = txLevel;
    }

    public void commit() {
        this.status.set(8);
        for (IDBResource dbResource : this.txRes.values()) {
            dbResource.commit();
            dbResource.close();
        }
        this.status.set(6);
    }

    public void rollback() {
        this.status.set(9);
        for (IDBResource dbResource : this.txRes.values()) {
            dbResource.rollback();
            dbResource.close();
        }
        this.status.set(6);
    }

    public boolean delistResource(XAResource xaResource, int arg1) throws IllegalStateException, SystemException {
        IDBResource dbResource = (IDBResource)((Object)xaResource);
        IResourceId resId = dbResource.getId();
        this.txRes.remove(resId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        IDBResource dbResource = (IDBResource)((Object)xaResource);
        IResourceId resId = dbResource.getId();
        if (this.txRes.get(resId) == null) {
            Map<IResourceId, IDBResource> map = this.txRes;
            synchronized (map) {
                if (this.txRes.get(resId) == null) {
                    dbResource.setTransactionIsolationLevel(this.txLevel);
                    this.txRes.put(resId, dbResource);
                }
            }
        }
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status.get();
    }

    public void registerSynchronization(Synchronization arg0) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
    }
}

