/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.utils;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.generator.annotations.DateTime;
import org.pinus4j.generator.annotations.PrimaryKey;
import org.pinus4j.generator.annotations.Table;
import org.pinus4j.generator.annotations.UpdateTime;
import org.pinus4j.utils.StringUtils;

public class ReflectUtil {
    private static final Map<Class<?>, String> _pkNameCache = new ConcurrentHashMap();
    public static final Map<Class<?>, Boolean> _tableCachedCache = new ConcurrentHashMap();
    public static final Map<Class<?>, Field[]> _fieldCache = new ConcurrentHashMap();
    public static final Map<Class<?>, String> _clusterNameCache = new ConcurrentHashMap();
    private static final Map<Class<?>, String> _tableNameCache = new ConcurrentHashMap();
    private static final Map<Class<?>, String> _shardingFieldCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Integer> _tableNumCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> _isShardingEntityCache = new ConcurrentHashMap();

    public static boolean isShardingEntity(Class<?> clazz) {
        Boolean isSharding = _isShardingEntityCache.get(clazz);
        if (isSharding == null) {
            Table annoTable = clazz.getAnnotation(Table.class);
            if (annoTable == null) {
                throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u5206\u7247\u7684\u6570\u636e\u5b9e\u4f53\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
            }
            String shardingField = annoTable.shardingBy();
            int shardingNum = annoTable.shardingNum();
            isSharding = StringUtils.isNotBlank(shardingField) || shardingNum > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            _isShardingEntityCache.put(clazz, isSharding);
        }
        return isSharding;
    }

    public static Number getPkValue(Object obj) {
        String pkName = ReflectUtil.getPkName(obj.getClass());
        try {
            return (Number)ReflectUtil.getProperty(obj, pkName);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u4e3b\u952e\u503c\u5931\u8d25" + e);
        }
    }

    public static void setPkValue(Object obj, Number pk) throws Exception {
        try {
            String pkName = ReflectUtil.getPkName(obj.getClass());
            ReflectUtil.setProperty(obj, pkName, pk);
        }
        catch (Exception e) {
            throw new Exception("\u8bbe\u7f6e\u4e3b\u952e\u503c\u5931\u8d25", e);
        }
    }

    public static String getPkName(Class<?> clazz) {
        Field[] fields;
        String pkName = _pkNameCache.get(clazz);
        if (pkName != null) {
            return pkName;
        }
        for (Field f : fields = ReflectUtil.getFields(clazz)) {
            if (f.getAnnotation(PrimaryKey.class) == null) continue;
            pkName = f.getName();
            break;
        }
        if (pkName == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u6807\u6ce8\u4e3b\u952e\u5c5e\u6027, class=" + clazz);
        }
        _pkNameCache.put(clazz, pkName);
        return pkName;
    }

    public static Object getShardingValue(Object entity) {
        Class<?> clazz = entity.getClass();
        String shardingField = _shardingFieldCache.get(clazz);
        if (shardingField == null) {
            Table annoTable = clazz.getAnnotation(Table.class);
            if (annoTable == null) {
                throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u5206\u7247\u7684\u6570\u636e\u5b9e\u4f53\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
            }
            shardingField = annoTable.shardingBy();
            _shardingFieldCache.put(clazz, shardingField);
        }
        Object shardingValue = null;
        try {
            shardingValue = ReflectUtil.getProperty(entity, shardingField);
        }
        catch (Exception e) {
            throw new DBOperationException("\u83b7\u53d6sharding value\u5931\u8d25, clazz=" + clazz + " field=" + shardingField);
        }
        if (shardingValue == null) {
            throw new IllegalStateException("shardingValue is null, clazz=" + clazz + " field=" + shardingField);
        }
        return shardingValue;
    }

    public static String getClusterName(Class<?> clazz) {
        String clusterName = _clusterNameCache.get(clazz);
        if (clusterName == null) {
            Table annoTable = clazz.getAnnotation(Table.class);
            if (annoTable == null) {
                throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u5206\u7247\u7684\u6570\u636e\u5b9e\u4f53\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
            }
            clusterName = annoTable.cluster();
            _clusterNameCache.put(clazz, clusterName);
        }
        return clusterName;
    }

    public static int getTableNum(Class<?> clazz) {
        Integer tableNum = _tableNumCache.get(clazz);
        if (tableNum == null) {
            Table annoTable = clazz.getAnnotation(Table.class);
            if (annoTable == null) {
                throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u5206\u7247\u7684\u6570\u636e\u5b9e\u4f53\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
            }
            tableNum = annoTable.shardingNum();
            _tableNumCache.put(clazz, tableNum);
        }
        return tableNum;
    }

    public static String getTableName(Object entity, int tableIndex) {
        Class<?> entityClass = entity.getClass();
        return ReflectUtil.getTableName(entityClass, tableIndex);
    }

    public static String getTableName(Class<?> clazz, int tableIndex) {
        if (tableIndex == -1) {
            return ReflectUtil.getTableName(clazz);
        }
        return ReflectUtil.getTableName(clazz) + tableIndex;
    }

    public static String getTableName(Class<?> clazz) {
        String tableName = _tableNameCache.get(clazz);
        if (tableName != null) {
            return tableName;
        }
        Table annoTable = clazz.getAnnotation(Table.class);
        if (annoTable == null) {
            throw new IllegalArgumentException(clazz + "\u65e0\u6cd5\u5206\u7247\u7684\u6570\u636e\u5b9e\u4f53\uff0c\u8bf7\u4f7f\u7528@Table\u6ce8\u89e3");
        }
        tableName = StringUtils.isBlank(annoTable.name()) ? clazz.getSimpleName() : annoTable.name();
        tableName = tableName.toLowerCase();
        _tableNameCache.put(clazz, tableName);
        return tableName;
    }

    public static boolean isCache(Class<?> clazz) {
        Boolean isCache = _tableCachedCache.get(clazz);
        if (isCache != null) {
            return isCache;
        }
        isCache = clazz.getAnnotation(Table.class).cache();
        _tableCachedCache.put(clazz, isCache);
        return isCache;
    }

    public static Object getProperty(Object obj, String propertyName) throws Exception {
        Field f = obj.getClass().getDeclaredField(propertyName);
        f.setAccessible(true);
        return f.get(obj);
    }

    public static void setProperty(Object obj, String propertyName, Object value) throws Exception {
        Field f = obj.getClass().getDeclaredField(propertyName);
        f.setAccessible(true);
        if (f.getType() == Boolean.TYPE) {
            f.setBoolean(obj, (Boolean)value);
        } else if (f.getType() == Integer.TYPE) {
            f.setInt(obj, ((Number)value).intValue());
        } else if (f.getType() == Byte.TYPE) {
            f.setByte(obj, ((Number)value).byteValue());
        } else if (f.getType() == Long.TYPE) {
            f.setLong(obj, ((Number)value).longValue());
        } else if (f.getType() == Short.TYPE) {
            f.setShort(obj, ((Number)value).shortValue());
        } else if (f.getType() == Float.TYPE) {
            f.setFloat(obj, ((Number)value).floatValue());
        } else if (f.getType() == Double.TYPE) {
            f.setDouble(obj, ((Number)value).doubleValue());
        } else {
            f.set(obj, value);
        }
    }

    public static Map<String, Object> describeWithoutUpdateTime(Object obj, boolean isFilteDefault) throws Exception {
        return ReflectUtil.describe(obj, isFilteDefault, true);
    }

    public static Map<String, Object> describe(Object obj) throws Exception {
        return ReflectUtil.describe(obj, false, false);
    }

    public static Map<String, Object> describe(Object obj, boolean isFilteDefault) throws Exception {
        return ReflectUtil.describe(obj, isFilteDefault, false);
    }

    public static Map<String, Object> describe(Object obj, boolean isFilteDefault, boolean isFilteUpdateTime) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, obj=null");
        }
        Class<?> objClass = obj.getClass();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Object value = null;
        for (Field f : ReflectUtil.getFields(objClass)) {
            f.setAccessible(true);
            if (f.getAnnotation(UpdateTime.class) != null) {
                if (isFilteUpdateTime) continue;
                f.set(obj, new Timestamp(System.currentTimeMillis()));
            }
            value = f.get(obj);
            Class<?> fTypeClazz = f.getType();
            org.pinus4j.generator.annotations.Field annoField = f.getAnnotation(org.pinus4j.generator.annotations.Field.class);
            if (fTypeClazz == String.class && annoField != null && annoField.length() > 4000 && value == null) {
                value = "";
            }
            if (isFilteDefault && value == null) continue;
            map.put(f.getName(), value);
        }
        return map;
    }

    public static Field[] getFields(Class<?> clazz) {
        Field[] fields = _fieldCache.get(clazz);
        if (fields != null) {
            return fields;
        }
        ArrayList<Field> mappingFields = new ArrayList<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (f.getAnnotation(PrimaryKey.class) != null) {
                mappingFields.add(f);
                continue;
            }
            if (f.getAnnotation(org.pinus4j.generator.annotations.Field.class) != null) {
                mappingFields.add(f);
                continue;
            }
            if (f.getAnnotation(DateTime.class) != null) {
                mappingFields.add(f);
                continue;
            }
            if (f.getAnnotation(UpdateTime.class) == null) continue;
            mappingFields.add(f);
        }
        if (mappingFields.isEmpty()) {
            throw new IllegalStateException("\u6ca1\u6709\u5305\u542b\u53ef\u4ee5\u64cd\u4f5c\u7684\u5217\u5c5e\u6027" + clazz);
        }
        fields = mappingFields.toArray(new Field[mappingFields.size()]);
        _fieldCache.put(clazz, fields);
        return fields;
    }

    public static Object cloneWithGivenField(Object obj, String ... fieldNames) throws Exception {
        if (fieldNames == null || fieldNames.length == 0) {
            return obj;
        }
        Object clone = obj.getClass().newInstance();
        Object value = null;
        for (String fieldName : fieldNames) {
            value = ReflectUtil.getProperty(obj, fieldName);
            ReflectUtil.setProperty(clone, fieldName, value);
        }
        return clone;
    }
}

