/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final Logger LOG = LoggerFactory.getLogger(XmlUtil.class);
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private Document xmlDoc;

    private XmlUtil() {
        InputStream is = null;
        String xmlFileName = "storage-config.xml";
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFileName);
            this.xmlDoc = builder.parse(new InputSource(is));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6classpath\u6839\u8def\u5f84\u7684xml\u5931\u8d25, file name " + xmlFileName);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    private XmlUtil(File xmlFile) {
        InputStream is = null;
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            is = new FileInputStream(xmlFile);
            this.xmlDoc = builder.parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6classpath\u6839\u8def\u5f84\u7684xml\u5931\u8d25, file " + xmlFile.getAbsolutePath());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    public static XmlUtil getInstance() {
        return new XmlUtil();
    }

    public static XmlUtil getInstance(File xmlFile) {
        return new XmlUtil(xmlFile);
    }

    public Node getRoot() {
        NodeList childs = this.xmlDoc.getChildNodes();
        if (childs == null || childs.getLength() == 0) {
            return null;
        }
        return this.xmlDoc.getChildNodes().item(0);
    }

    public Node getFirstChildByName(Node parent, String name) {
        NodeList childs = parent.getChildNodes();
        if (childs == null || childs.getLength() == 0) {
            return null;
        }
        Node node = null;
        for (int i = 0; i < childs.getLength(); ++i) {
            node = childs.item(i);
            if (!node.getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public List<Node> getChildByName(Node parent, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList childs = parent.getChildNodes();
        if (childs == null || childs.getLength() == 0) {
            return null;
        }
        Node node = null;
        for (int i = 0; i < childs.getLength(); ++i) {
            node = childs.item(i);
            if (!node.getNodeName().equals(name)) continue;
            list.add(node);
        }
        return list;
    }

    public String getAttributeValue(Node node, String attribute) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node attrNode = namedNodeMap.getNamedItem(attribute);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getNodeValue();
    }
}

