/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.pinus4j.api.PinusClient;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.ResultSetableQueryImpl;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.cluster.beans.IShardingKey;
import org.pinus4j.cluster.enums.EnumDB;
import org.pinus4j.cluster.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.enums.EnumSyncAction;
import org.pinus4j.cluster.impl.DefaultDBClusterBuilder;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.datalayer.JdbcDataLayerBuilder;
import org.pinus4j.datalayer.query.IGlobalQuery;
import org.pinus4j.datalayer.query.IShardingQuery;
import org.pinus4j.datalayer.update.IGlobalUpdate;
import org.pinus4j.datalayer.update.IShardingUpdate;
import org.pinus4j.entity.DefaultEntityMetaManager;
import org.pinus4j.entity.IEntityMetaManager;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.generator.IIdGenerator;
import org.pinus4j.task.ITask;
import org.pinus4j.task.TaskExecutor;
import org.pinus4j.task.TaskFuture;
import org.pinus4j.transaction.enums.EnumTransactionIsolationLevel;
import org.pinus4j.transaction.impl.BestEffortsOnePCJtaTransaction;
import org.pinus4j.transaction.impl.BestEffortsOnePCJtaTransactionManager;
import org.pinus4j.utils.BeansUtil;
import org.pinus4j.utils.CheckUtil;
import org.pinus4j.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPinusClient
implements PinusClient {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultPinusClient.class);
    public static PinusClient instance;
    private EnumDB enumDb = EnumDB.MYSQL;
    private EnumSyncAction syncAction = EnumSyncAction.CREATE;
    private String scanPackage;
    private IIdGenerator idGenerator;
    private IDBCluster dbCluster;
    private TransactionManager txManager;
    private IGlobalUpdate globalUpdater;
    private IGlobalQuery globalQuery;
    private IShardingUpdate shardingUpdater;
    private IShardingQuery shardingQuery;
    private IEntityMetaManager entityMetaManager = DefaultEntityMetaManager.getInstance();

    @Override
    public void init() {
        DefaultDBClusterBuilder dbClusterBuilder = new DefaultDBClusterBuilder();
        dbClusterBuilder.setScanPackage(this.scanPackage);
        dbClusterBuilder.setSyncAction(this.syncAction);
        dbClusterBuilder.setDbType(this.enumDb);
        this.dbCluster = dbClusterBuilder.build();
        this.idGenerator = this.dbCluster.getIdGenerator();
        this.txManager = this.dbCluster.getTransactionManager();
        IDataLayerBuilder dataLayerBuilder = JdbcDataLayerBuilder.valueOf(this.dbCluster);
        dataLayerBuilder.setPrimaryCache(this.dbCluster.getPrimaryCache());
        dataLayerBuilder.setSecondCache(this.dbCluster.getSecondCache());
        this.globalUpdater = dataLayerBuilder.buildGlobalUpdate(this.dbCluster.getIdGenerator());
        this.globalQuery = dataLayerBuilder.buildGlobalQuery();
        this.shardingUpdater = dataLayerBuilder.buildShardingUpdate(this.dbCluster.getIdGenerator());
        this.shardingQuery = dataLayerBuilder.buildShardingQuery();
        instance = this;
    }

    @Override
    public void destroy() {
        try {
            this.dbCluster.shutdown();
        }
        catch (DBClusterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beginTransaction() {
        this.beginTransaction(EnumTransactionIsolationLevel.READ_COMMITTED);
    }

    @Override
    public void beginTransaction(EnumTransactionIsolationLevel txLevel) {
        ((BestEffortsOnePCJtaTransactionManager)this.txManager).setTransactionIsolationLevel(txLevel);
        try {
            this.txManager.begin();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.txManager.commit();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.txManager.rollback();
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public void flush() {
        try {
            BestEffortsOnePCJtaTransaction localTx = (BestEffortsOnePCJtaTransaction)this.txManager.getTransaction();
            if (localTx != null) {
                localTx.flush();
            }
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> TaskFuture submit(ITask<T> task, Class<T> clazz) {
        TaskExecutor<T> taskExecutor = new TaskExecutor<T>(clazz, this.dbCluster);
        return taskExecutor.execute(task);
    }

    @Override
    public <T> TaskFuture submit(ITask<T> task, Class<T> clazz, IQuery<T> query) {
        TaskExecutor<T> taskExecutor = new TaskExecutor<T>(clazz, this.dbCluster);
        return taskExecutor.execute(task, query);
    }

    @Override
    public void save(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        Class<?> clazz = entity.getClass();
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            CheckUtil.checkShardingEntity(entity);
            IShardingKey sk = this.entityMetaManager.getShardingKey(entity);
            CheckUtil.checkShardingKey(sk);
            this.shardingUpdater.save(entity, sk);
        } else {
            CheckUtil.checkGlobalEntity(entity);
            String clusterName = this.entityMetaManager.getClusterName(entity.getClass());
            CheckUtil.checkClusterName(clusterName);
            this.globalUpdater.save(entity, clusterName);
        }
    }

    @Override
    public void saveBatch(List<? extends Object> entityList) {
        this.saveBatch(entityList, true);
    }

    @Override
    public void saveBatch(List<? extends Object> entityList, boolean autoGeneratedKeys) {
        if (entityList == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        ArrayList globalList = Lists.newArrayList();
        ArrayList shardingList = Lists.newArrayList();
        for (Object object : entityList) {
            if (this.entityMetaManager.isShardingEntity(object.getClass())) {
                shardingList.add(object);
                continue;
            }
            globalList.add(object);
        }
        if (!globalList.isEmpty()) {
            HashMap clusterEntityMap = Maps.newHashMap();
            Object var6_7 = null;
            for (Object e : globalList) {
                String string = this.entityMetaManager.getClusterName(e.getClass());
                List theSameClusterNameList = (List)clusterEntityMap.get(string);
                if (theSameClusterNameList != null) {
                    theSameClusterNameList.add(e);
                    continue;
                }
                theSameClusterNameList = Lists.newArrayList((Object[])new Object[]{e});
                clusterEntityMap.put(string, theSameClusterNameList);
            }
            for (Map.Entry entry : clusterEntityMap.entrySet()) {
                this.globalUpdater.saveBatch((List)entry.getValue(), (String)entry.getKey(), autoGeneratedKeys);
            }
        }
        if (!shardingList.isEmpty()) {
            HashMap theSameShardingKeyMap = Maps.newHashMap();
            Object var6_11 = null;
            for (Object object : shardingList) {
                IShardingKey iShardingKey = this.entityMetaManager.getShardingKey(object);
                List theSameShardingKeyList = (List)theSameShardingKeyMap.get(iShardingKey);
                if (theSameShardingKeyList != null) {
                    theSameShardingKeyList.add(object);
                    continue;
                }
                theSameShardingKeyList = Lists.newArrayList((Object[])new Object[]{object});
                theSameShardingKeyMap.put(iShardingKey, theSameShardingKeyList);
            }
            for (Map.Entry entry : theSameShardingKeyMap.entrySet()) {
                this.shardingUpdater.saveBatch((List)entry.getValue(), (IShardingKey)entry.getKey(), autoGeneratedKeys);
            }
        }
    }

    @Override
    public void update(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        Class<?> clazz = entity.getClass();
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            CheckUtil.checkShardingEntity(entity);
            IShardingKey sk = this.entityMetaManager.getShardingKey(entity);
            CheckUtil.checkShardingKey(sk);
            this.shardingUpdater.update(entity, sk);
        } else {
            CheckUtil.checkGlobalEntity(entity);
            String clusterName = this.entityMetaManager.getClusterName(entity.getClass());
            CheckUtil.checkClusterName(clusterName);
            this.globalUpdater.update(entity, clusterName);
        }
    }

    @Override
    public void updateBatch(List<? extends Object> entityList) {
        if (entityList == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        ArrayList globalList = Lists.newArrayList();
        ArrayList shardingList = Lists.newArrayList();
        for (Object object : entityList) {
            if (this.entityMetaManager.isShardingEntity(object.getClass())) {
                shardingList.add(object);
                continue;
            }
            globalList.add(object);
        }
        if (!globalList.isEmpty()) {
            HashMap theSameClusterNameMap = Maps.newHashMap();
            Object var5_6 = null;
            for (Object e : globalList) {
                String string = this.entityMetaManager.getClusterName(e.getClass());
                List theSameClusterNameList = (List)theSameClusterNameMap.get(string);
                if (theSameClusterNameList != null) {
                    theSameClusterNameList.add(e);
                    continue;
                }
                theSameClusterNameList = Lists.newArrayList((Object[])new Object[]{e});
                theSameClusterNameMap.put(string, theSameClusterNameList);
            }
            for (Map.Entry entry : theSameClusterNameMap.entrySet()) {
                this.globalUpdater.updateBatch((List)entry.getValue(), (String)entry.getKey());
            }
        }
        if (!shardingList.isEmpty()) {
            HashMap theSameShardingKeyMap = Maps.newHashMap();
            Object var5_10 = null;
            for (Object object : shardingList) {
                IShardingKey iShardingKey = this.entityMetaManager.getShardingKey(object);
                List theSameShardingKeyList = (List)theSameShardingKeyMap.get(iShardingKey);
                if (theSameShardingKeyList != null) {
                    theSameShardingKeyList.add(object);
                    continue;
                }
                theSameShardingKeyList = Lists.newArrayList((Object[])new Object[]{object});
                theSameShardingKeyMap.put(iShardingKey, theSameShardingKeyList);
            }
            for (Map.Entry entry : theSameShardingKeyMap.entrySet()) {
                this.shardingUpdater.updateBatch((List)entry.getValue(), (IShardingKey)entry.getKey());
            }
        }
    }

    @Override
    public void delete(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        Class<?> clazz = entity.getClass();
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            CheckUtil.checkShardingEntity(entity);
            EntityPK entityPk = this.entityMetaManager.getEntityPK(entity);
            IShardingKey shardingKey = this.entityMetaManager.getShardingKey(entity);
            this.shardingUpdater.removeByPk(entityPk, shardingKey, clazz);
        } else {
            CheckUtil.checkGlobalEntity(entity);
            EntityPK entityPk = this.entityMetaManager.getEntityPK(entity);
            String clusterName = this.entityMetaManager.getClusterName(clazz);
            this.globalUpdater.removeByPk(entityPk, clazz, clusterName);
        }
    }

    @Override
    public void delete(List<? extends Object> entityList) {
        ArrayList pks;
        List theSameClassList;
        Class<?> clazz;
        HashMap theSameClassMap;
        if (entityList == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        ArrayList globalList = Lists.newArrayList();
        ArrayList shardingList = Lists.newArrayList();
        for (Object object : entityList) {
            if (this.entityMetaManager.isShardingEntity(object.getClass())) {
                shardingList.add(object);
                continue;
            }
            globalList.add(object);
        }
        if (!globalList.isEmpty()) {
            HashMap theSameClusterNameMap = Maps.newHashMap();
            Object var5_6 = null;
            for (Object e : globalList) {
                String string = this.entityMetaManager.getClusterName(e.getClass());
                List theSameClusterNameList = (List)theSameClusterNameMap.get(string);
                if (theSameClusterNameList != null) {
                    theSameClusterNameList.add(e);
                    continue;
                }
                theSameClusterNameList = Lists.newArrayList((Object[])new Object[]{e});
                theSameClusterNameMap.put(string, theSameClusterNameList);
            }
            for (Map.Entry entry : theSameClusterNameMap.entrySet()) {
                theSameClassMap = Maps.newHashMap();
                clazz = null;
                for (Object sameClusterNameEntity : (List)entry.getValue()) {
                    clazz = sameClusterNameEntity.getClass();
                    theSameClassList = (List)theSameClassMap.get(clazz);
                    if (theSameClassList != null) {
                        theSameClassList.add(sameClusterNameEntity);
                    } else {
                        theSameClassMap.put(clazz, Lists.newArrayList((Object[])new Object[]{sameClusterNameEntity}));
                    }
                    for (Map.Entry sameClassEntry : theSameClassMap.entrySet()) {
                        pks = Lists.newArrayList();
                        for (Object sameClassEntity : (List)sameClassEntry.getValue()) {
                            pks.add(this.entityMetaManager.getEntityPK(sameClassEntity));
                        }
                        this.globalUpdater.removeByPks(pks, (Class)sameClassEntry.getKey(), (String)entry.getKey());
                    }
                }
            }
        }
        if (!shardingList.isEmpty()) {
            HashMap theSameShardingKeyMap = Maps.newHashMap();
            Object var5_10 = null;
            for (Object object : shardingList) {
                IShardingKey iShardingKey = this.entityMetaManager.getShardingKey(object);
                List theSameShardingKeyList = (List)theSameShardingKeyMap.get(iShardingKey);
                if (theSameShardingKeyList != null) {
                    theSameShardingKeyList.add(object);
                    continue;
                }
                theSameShardingKeyList = Lists.newArrayList((Object[])new Object[]{object});
                theSameShardingKeyMap.put(iShardingKey, theSameShardingKeyList);
            }
            for (Map.Entry entry : theSameShardingKeyMap.entrySet()) {
                theSameClassMap = Maps.newHashMap();
                clazz = null;
                for (Object sameShardingKeyEntity : (List)entry.getValue()) {
                    clazz = sameShardingKeyEntity.getClass();
                    theSameClassList = (List)theSameClassMap.get(clazz);
                    if (theSameClassList != null) {
                        theSameClassList.add(sameShardingKeyEntity);
                    } else {
                        theSameClassMap.put(clazz, Lists.newArrayList((Object[])new Object[]{sameShardingKeyEntity}));
                    }
                    for (Map.Entry sameClassEntry : theSameClassMap.entrySet()) {
                        pks = Lists.newArrayList();
                        for (Object sameClassEntity : (List)sameClassEntry.getValue()) {
                            pks.add(this.entityMetaManager.getEntityPK(sameClassEntity));
                        }
                        this.shardingUpdater.removeByPks(pks, (IShardingKey)entry.getKey(), (Class)sameClassEntry.getKey());
                    }
                }
            }
        }
    }

    @Override
    public void load(Object entity) {
        this.load(entity, true, EnumDBMasterSlave.AUTO);
    }

    @Override
    public void load(Object entity, boolean useCache) {
        this.load(entity, useCache, EnumDBMasterSlave.AUTO);
    }

    @Override
    public void load(Object entity, EnumDBMasterSlave masterSlave) {
        this.load(entity, true, masterSlave);
    }

    @Override
    public void load(Object entity, boolean useCache, EnumDBMasterSlave masterSlave) {
        if (entity == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        EntityPK entityPk = this.entityMetaManager.getEntityPK(entity);
        Object loadEntity = null;
        Class<?> clazz = entity.getClass();
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            IShardingKey shardingKey = this.entityMetaManager.getShardingKey(entity);
            loadEntity = this.shardingQuery.findByPk(entityPk, shardingKey, clazz, useCache, masterSlave);
        } else {
            loadEntity = this.globalQuery.findByPk(entityPk, clazz, useCache, masterSlave);
        }
        if (loadEntity == null) {
            throw new DBOperationException("\u627e\u4e0d\u5230\u8bb0\u5f55, pk=" + entityPk);
        }
        try {
            BeansUtil.copyProperties(loadEntity, (Object)entity);
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> IQuery<T> createQuery(Class<T> clazz) {
        ResultSetableQueryImpl<T> query = new ResultSetableQueryImpl<T>(clazz);
        query.setGlobalQuery(this.globalQuery);
        query.setShardingQuery(this.shardingQuery);
        return query;
    }

    @Override
    public List<Map<String, Object>> findBySQL(SQL sql, Class<?> clazz) {
        if (sql == null) {
            throw new IllegalArgumentException("param sql should not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("param class should not be null");
        }
        CheckUtil.checkSQL(sql);
        CheckUtil.checkClass(clazz);
        String clusterName = this.entityMetaManager.getClusterName(clazz);
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            return this.shardingQuery.findBySql(sql, EnumDBMasterSlave.AUTO);
        }
        return this.globalQuery.findBySql(sql, clusterName, EnumDBMasterSlave.AUTO);
    }

    @Override
    public List<Map<String, Object>> findBySQL(SQL sql, String clusterName) {
        if (sql == null) {
            throw new IllegalArgumentException("param sql should not be null");
        }
        CheckUtil.checkSQL(sql);
        return this.globalQuery.findBySql(sql, clusterName, EnumDBMasterSlave.AUTO);
    }

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.dbCluster.getPrimaryCache();
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.dbCluster.getSecondCache();
    }

    @Override
    public int genClusterUniqueIntId(String name) {
        return this.idGenerator.genClusterUniqueIntId("/pinus/sequence", name);
    }

    @Override
    public long genClusterUniqueLongId(String name) {
        return this.idGenerator.genClusterUniqueLongId("/pinus/sequence", name);
    }

    @Override
    public long[] genClusterUniqueLongIdBatch(String name, int batchSize) {
        return this.idGenerator.genClusterUniqueLongIdBatch("/pinus/sequence", name, batchSize);
    }

    @Override
    public int[] genClusterUniqueIntIdBatch(String name, int batchSize) {
        return this.idGenerator.genClusterUniqueIntIdBatch("/pinus/sequence", name, batchSize);
    }

    @Override
    public Lock createLock(String lockName) {
        return this.dbCluster.createLock(lockName);
    }

    public EnumSyncAction getSyncAction() {
        return this.syncAction;
    }

    @Override
    public void setSyncAction(EnumSyncAction syncAction) {
        this.syncAction = syncAction;
    }

    public String getScanPackage() {
        return this.scanPackage;
    }

    @Override
    public void setScanPackage(String scanPackage) {
        if (StringUtil.isBlank((String)scanPackage)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scanPackage = scanPackage;
    }
}

