/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.pinus4j.api.DefaultPinusClient;
import org.pinus4j.api.PinusClient;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.Condition;
import org.pinus4j.cluster.beans.IShardingKey;
import org.pinus4j.entity.DefaultEntityMetaManager;
import org.pinus4j.entity.IEntityMetaManager;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKName;
import org.pinus4j.entity.meta.PKValue;

public abstract class FashionEntity {
    private IEntityMetaManager entityMetaManager = DefaultEntityMetaManager.getInstance();

    public void load() {
        PinusClient pinusClient = DefaultPinusClient.instance;
        pinusClient.load(this);
    }

    public void save() {
        PinusClient pinusClient = DefaultPinusClient.instance;
        pinusClient.save(this);
    }

    public void update() {
        PinusClient pinusClient = DefaultPinusClient.instance;
        pinusClient.update(this);
    }

    public void saveOrUpdate() {
        Object obj;
        Class<?> clazz = this.getClass();
        PinusClient pinusClient = DefaultPinusClient.instance;
        EntityPK entityPK = this.entityMetaManager.getEntityPK((Object)this);
        IQuery<?> query = pinusClient.createQuery(clazz);
        ArrayList orCond = Lists.newArrayList();
        PKName[] pkNames = entityPK.getPkNames();
        PKValue[] pkValues = entityPK.getPkValues();
        for (int i = 0; i < pkNames.length; ++i) {
            orCond.add(Condition.eq(pkNames[i].getValue(), pkValues[i].getValue()));
        }
        query.and(Condition.or(orCond.toArray(new Condition[orCond.size()])));
        if (this.entityMetaManager.isShardingEntity(clazz)) {
            IShardingKey sk = this.entityMetaManager.getShardingKey((Object)this);
            query.setShardingKey(sk);
        }
        if ((obj = query.load()) != null) {
            this.update();
        } else {
            this.save();
        }
    }

    public void remove() {
        PinusClient pinusClient = DefaultPinusClient.instance;
        pinusClient.delete(this);
    }
}

