/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api;

import java.util.Arrays;
import java.util.List;
import org.pinus4j.datalayer.SQLParser;

public class SQL {
    private String sql;
    private List<Object> params;

    private SQL() {
    }

    private SQL(String sql, List<Object> paramList) {
        this.sql = sql;
        this.params = paramList;
    }

    public static final SQL valueOf(String sql, Object ... params) {
        return new SQL(sql, Arrays.asList(params));
    }

    public static final SQL valueOf(String sql, List<Object> paramList) {
        return new SQL(sql, paramList);
    }

    public List<String> getTableNames() {
        return SQLParser.parseTableName(this.sql);
    }

    public String getSecondCacheKey() {
        StringBuilder key = new StringBuilder(this.sql);
        key.append("[");
        for (Object param : this.params) {
            key.append(param).append(",");
        }
        if (!this.params.isEmpty()) {
            key.deleteCharAt(key.length() - 1);
        }
        key.append("]");
        return key.toString();
    }

    public String toString() {
        return this.sql;
    }

    public String getSql() {
        return this.sql;
    }

    public List<Object> getParams() {
        return this.params;
    }
}

