/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api.query.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.api.query.impl.QueryOpt;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.utils.BeansUtil;
import org.pinus4j.utils.StringUtil;

public class Condition {
    private String field;
    private Object value;
    private QueryOpt opt;
    private Condition[] orCond;
    private Condition[] andCond;
    private DefaultQueryImpl.ConditionRelation conditionRelation;

    private Condition() {
    }

    private Condition(String field, Object value, QueryOpt opt, Class<?> clazz) {
        if (StringUtil.isBlank((String)field)) {
            throw new IllegalArgumentException("\u6761\u4ef6\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a, condition field=" + field);
        }
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=" + value);
        }
        if (value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value\u662f\u6570\u7ec4\u5e76\u4e14\u6570\u7ec4\u957f\u5ea6\u4e3a0");
        }
        this.field = field;
        if (clazz != null) {
            this.field = BeansUtil.getFieldName((Field)BeansUtil.getField(clazz, (String)field));
        }
        this.value = SQLBuilder.formatValue(value);
        this.opt = opt;
    }

    private Condition(String field, QueryOpt opt, Class<?> clazz) {
        if (StringUtil.isBlank((String)field)) {
            throw new IllegalArgumentException("\u6761\u4ef6\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a, condition field=" + field);
        }
        this.field = field;
        if (clazz != null) {
            this.field = BeansUtil.getFieldName((Field)BeansUtil.getField(clazz, (String)field));
        }
        this.opt = opt;
    }

    SQL getSql() {
        StringBuilder sqlText = new StringBuilder();
        if (this.orCond != null && this.orCond.length > 0) {
            ArrayList paramList = Lists.newArrayList();
            sqlText.append("(");
            for (Condition cond : this.orCond) {
                sqlText.append(cond.getSql().getSql()).append(" or ");
                paramList.addAll(cond.getSql().getParams());
            }
            sqlText.delete(sqlText.lastIndexOf(" or "), sqlText.length());
            sqlText.append(")");
            return SQL.valueOf(sqlText.toString(), paramList.toArray(new Object[paramList.size()]));
        }
        if (this.andCond != null && this.andCond.length > 0) {
            ArrayList paramList = Lists.newArrayList();
            sqlText.append("(");
            for (Condition cond : this.andCond) {
                sqlText.append(cond.getSql().getSql()).append(" and ");
                paramList.addAll(cond.getSql().getParams());
            }
            sqlText.delete(sqlText.lastIndexOf(" and "), sqlText.length());
            sqlText.append(")");
            return SQL.valueOf(sqlText.toString(), paramList.toArray(new Object[paramList.size()]));
        }
        sqlText.append('`').append(this.field).append('`').append(" ").append(this.opt.getSymbol()).append(" ");
        ArrayList paramList = Lists.newArrayList();
        switch (this.opt) {
            case IN: {
                int paramLength = Array.getLength(this.value);
                sqlText.append("(");
                for (int i = 0; i < paramLength; ++i) {
                    sqlText.append('?').append(',');
                    Object val = Array.get(this.value, i);
                    Class<?> clazz = val.getClass();
                    if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                        if (((Boolean)val).booleanValue()) {
                            paramList.add("1");
                            continue;
                        }
                        paramList.add("0");
                        continue;
                    }
                    paramList.add(val);
                }
                sqlText.deleteCharAt(sqlText.length() - 1);
                sqlText.append(")");
                break;
            }
            case ISNULL: {
                break;
            }
            case ISNOTNULL: {
                break;
            }
            default: {
                sqlText.append('?');
                Object value = this.value;
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        paramList.add("1");
                        break;
                    }
                    paramList.add("0");
                    break;
                }
                paramList.add(value);
            }
        }
        return SQL.valueOf(sqlText.toString(), paramList);
    }

    public String toString() {
        return this.getSql().toString();
    }

    public static Condition eq(String field, Object value) {
        return Condition.eq(field, value, null);
    }

    public static Condition eq(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.EQ, clazz);
        return cond;
    }

    public static Condition noteq(String field, Object value) {
        return Condition.noteq(field, value, null);
    }

    public static Condition noteq(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.NOTEQ, clazz);
        return cond;
    }

    public static Condition gt(String field, Object value) {
        return Condition.gt(field, value, null);
    }

    public static Condition gt(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.GT, clazz);
        return cond;
    }

    public static Condition gte(String field, Object value) {
        return Condition.gte(field, value, null);
    }

    public static Condition gte(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.GTE, clazz);
        return cond;
    }

    public static Condition lt(String field, Object value) {
        return Condition.lt(field, value, null);
    }

    public static Condition lt(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LT, clazz);
        return cond;
    }

    public static Condition lte(String field, Object value) {
        return Condition.lte(field, value, null);
    }

    public static Condition lte(String field, Object value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LTE, clazz);
        return cond;
    }

    public static Condition in(String field, List<? extends Object> values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, List<? extends Object> values, Class<?> clazz) {
        return Condition.in(field, clazz, values.toArray(new Object[values.size()]));
    }

    public static Condition in(String field, Set<? extends Object> values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, Set<? extends Object> values, Class<?> clazz) {
        return Condition.in(field, clazz, values.toArray(new Object[values.size()]));
    }

    public static Condition in(String field, Object ... values) {
        return Condition.in(field, null, values);
    }

    public static Condition in(String field, Class<?> clazz, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, byte[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, byte[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, int[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, int[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, short[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, short[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, long[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, long[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, float[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, float[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, double[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, double[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition in(String field, boolean[] values) {
        return Condition.in(field, values, null);
    }

    public static Condition in(String field, boolean[] values, Class<?> clazz) {
        if (values == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, values, QueryOpt.IN, clazz);
        return cond;
    }

    public static Condition like(String field, String value) {
        return Condition.like(field, value, null);
    }

    public static Condition like(String field, String value, Class<?> clazz) {
        if (value == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, condition value=null");
        }
        Condition cond = new Condition(field, value, QueryOpt.LIKE, clazz);
        return cond;
    }

    public static Condition or(Condition ... conds) {
        if (conds == null || conds.length < 2) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, or\u67e5\u8be2\u6761\u4ef6\u6700\u5c11\u4e3a2\u4e2a");
        }
        Condition cond = new Condition();
        cond.setOrCond(conds);
        return cond;
    }

    public static Condition and(Condition ... conds) {
        if (conds == null || conds.length < 2) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, and\u67e5\u8be2\u6761\u4ef6\u6700\u5c11\u4e3a2\u4e2a");
        }
        Condition cond = new Condition();
        cond.setAndCond(conds);
        return cond;
    }

    public static Condition isNull(String field) {
        return Condition.isNull(field, null);
    }

    public static Condition isNull(String field, Class<?> clazz) {
        Condition cond = new Condition(field, QueryOpt.ISNULL, clazz);
        return cond;
    }

    public static Condition isNotNull(String field) {
        return Condition.isNotNull(field, null);
    }

    public static Condition isNotNull(String field, Class<?> clazz) {
        Condition cond = new Condition(field, QueryOpt.ISNOTNULL, clazz);
        return cond;
    }

    boolean isAndCondAllEQ() {
        if (this.andCond.length == 0) {
            return false;
        }
        for (Condition oneAnd : this.andCond) {
            if (oneAnd.getOpt() == QueryOpt.EQ) continue;
            return false;
        }
        return true;
    }

    String getField() {
        return this.field;
    }

    void setField(String field) {
        this.field = field;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    QueryOpt getOpt() {
        return this.opt;
    }

    void setOpt(QueryOpt opt) {
        this.opt = opt;
    }

    Condition[] getOrCond() {
        return this.orCond;
    }

    void setOrCond(Condition[] orCond) {
        this.orCond = orCond;
    }

    Condition[] getAndCond() {
        return this.andCond;
    }

    void setAndCond(Condition[] andCond) {
        this.andCond = andCond;
    }

    DefaultQueryImpl.ConditionRelation getConditionRelation() {
        return this.conditionRelation;
    }

    void setConditionRelation(DefaultQueryImpl.ConditionRelation conditionRelation) {
        this.conditionRelation = conditionRelation;
    }
}

