/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.api.query.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.Condition;
import org.pinus4j.api.query.impl.Order;
import org.pinus4j.api.query.impl.QueryOpt;
import org.pinus4j.cluster.beans.IShardingKey;
import org.pinus4j.cluster.enums.EnumDBMasterSlave;
import org.pinus4j.utils.BeansUtil;
import org.pinus4j.utils.StringUtil;

public class DefaultQueryImpl<T>
implements IQuery<T>,
Cloneable {
    protected Class<T> clazz;
    protected String[] fields;
    protected List<Condition> condList = new ArrayList<Condition>();
    protected List<OrderBy> orderList = new ArrayList<OrderBy>();
    protected int start = -1;
    protected int limit = -1;

    @Override
    public T load() {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public List<T> list() {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public Number count() {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public IQuery<T> setShardingKey(IShardingKey<?> shardingKey) {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public IQuery<T> setMasterSlave(EnumDBMasterSlave masterSlave) {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public IQuery<T> setUseCache(boolean useCache) {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public IQuery<T> setFields(String ... fields) {
        if (fields != null && fields.length > 0) {
            this.fields = fields;
        }
        return this;
    }

    @Override
    public IQuery<T> setFields(Class<?> clazz, String ... fields) {
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                field = BeansUtil.getFieldName((Field)BeansUtil.getField(clazz, (String)field));
            }
            this.fields = fields;
        }
        return this;
    }

    @Override
    @Deprecated
    public IQuery<T> add(Condition cond) {
        return this.and(cond);
    }

    @Override
    public IQuery<T> and(Condition cond) {
        if (cond == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        if (!this.condList.isEmpty()) {
            cond.setConditionRelation(ConditionRelation.AND);
        }
        this.condList.add(cond);
        return this;
    }

    @Override
    public IQuery<T> or(Condition cond) {
        if (cond == null) {
            throw new IllegalArgumentException("param should not be null");
        }
        if (!this.condList.isEmpty()) {
            cond.setConditionRelation(ConditionRelation.OR);
        }
        this.condList.add(cond);
        return this;
    }

    @Override
    public IQuery<T> orderBy(String field, Order order) {
        return this.orderBy(field, order, this.clazz);
    }

    @Override
    public IQuery<T> orderBy(String field, Order order, Class<?> clazz) {
        if (StringUtil.isBlank((String)field)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, field=" + field);
        }
        if (order == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef, order=null");
        }
        this.orderList.add(new OrderBy(field, order, clazz));
        return this;
    }

    @Override
    public IQuery<T> limit(int start, int limit) {
        if (start < 0 || limit <= 0) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef, start" + start + ", limit=" + limit);
        }
        this.start = start;
        this.limit = limit;
        return this;
    }

    @Override
    public IQuery<T> limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("\u8bbe\u7f6elimit\u53c2\u6570\u9519\u8bef\uff0c limit=" + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public void clean() {
        this.fields = null;
        this.condList.clear();
        this.orderList.clear();
        this.start = -1;
        this.limit = -1;
    }

    public String[] getFields() {
        return this.fields;
    }

    public List<Condition> getCondList() {
        return this.condList;
    }

    public List<OrderBy> getOrderList() {
        return this.orderList;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean hasQueryFields() {
        return this.fields != null && this.fields.length > 0;
    }

    public boolean isEffect() {
        return !this.condList.isEmpty() || !this.orderList.isEmpty() || this.start != -1 || this.limit != -1;
    }

    @Override
    public IQuery<T> clone() {
        DefaultQueryImpl<T> clone = new DefaultQueryImpl<T>();
        clone.fields = this.fields;
        clone.condList.addAll(this.condList);
        clone.orderList.addAll(this.orderList);
        clone.start = this.start;
        clone.limit = this.limit;
        return clone;
    }

    public SQL getWhereSql() {
        StringBuilder sqlText = new StringBuilder();
        StringBuilder whereSql = new StringBuilder();
        StringBuilder orderSql = new StringBuilder();
        StringBuilder findInSet = new StringBuilder();
        ArrayList paramList = Lists.newArrayList();
        ArrayList inConditionList = Lists.newArrayList();
        if (!this.condList.isEmpty()) {
            whereSql.append(" where ");
            Condition cond = null;
            for (int i = 0; i < this.condList.size(); ++i) {
                cond = this.condList.get(i);
                if (i > 0) {
                    whereSql.append(" ").append(cond.getConditionRelation().getValue()).append(" ").append(cond.getSql().getSql());
                } else {
                    whereSql.append(cond.getSql().getSql());
                }
                if (QueryOpt.IN == cond.getOpt()) {
                    inConditionList.add(cond);
                }
                paramList.addAll(cond.getSql().getParams());
            }
            if (!inConditionList.isEmpty() && inConditionList.size() == 1) {
                Condition inCondition = (Condition)inConditionList.get(0);
                findInSet.append("find_in_set(").append(inCondition.getField()).append(",'");
                for (Object param : inCondition.getSql().getParams()) {
                    findInSet.append(param).append(',');
                }
                findInSet.deleteCharAt(findInSet.length() - 1);
                findInSet.append("')");
            }
        }
        if (this.orderList != null && !this.orderList.isEmpty()) {
            orderSql.append(" order by ");
            for (OrderBy orderBy : this.orderList) {
                orderSql.append('`').append(orderBy.getField()).append('`');
                orderSql.append(" ");
                orderSql.append(orderBy.getOrder().getValue());
                orderSql.append(",");
            }
            orderSql.deleteCharAt(orderSql.length() - 1);
        } else if (StringUtil.isNotBlank((String)findInSet.toString())) {
            orderSql.append(" order by ");
            orderSql.append((CharSequence)findInSet);
        }
        sqlText.append((CharSequence)whereSql);
        sqlText.append((CharSequence)orderSql);
        if (this.start > -1 && this.limit > -1) {
            sqlText.append(" limit ?,?");
            paramList.add(this.start);
            paramList.add(this.limit);
        } else if (this.limit != -1) {
            sqlText.append(" limit ?");
            paramList.add(this.limit);
        }
        return SQL.valueOf(sqlText.toString(), paramList);
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (this.fields != null && this.fields.length > 0) {
            info.append("fields:");
            for (String field : this.fields) {
                info.append(field).append(",");
            }
            info.deleteCharAt(info.length() - 1);
        }
        if (StringUtil.isNotBlank((String)this.getWhereSql().getSql())) {
            info.append(" wheresql:").append(this.getWhereSql());
        }
        return info.toString();
    }

    public void setCondList(List<Condition> condList) {
        this.condList = condList;
    }

    public void setOrderList(List<OrderBy> orderList) {
        this.orderList = orderList;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    static enum ConditionRelation {
        AND("and"),
        OR("or");

        private String value;

        private ConditionRelation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class OrderBy {
        private String field;
        private Class<?> fieldType;
        private Order order;

        public OrderBy(String field, Order order, Class<?> clazz) {
            Field f = BeansUtil.getField(clazz, (String)field);
            this.field = clazz != null ? BeansUtil.getFieldName((Field)f) : field;
            this.fieldType = f.getType();
            this.order = order;
        }

        public String getField() {
            return this.field;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public Order getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderBy [field=" + this.field + ", fieldType=" + this.fieldType + ", order=" + (Object)((Object)this.order) + "]";
        }
    }
}

