/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.transaction.TransactionManager;
import org.pinus4j.api.SQL;
import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.datalayer.IDataLayer;
import org.pinus4j.entity.DefaultEntityMetaManager;
import org.pinus4j.entity.IEntityMetaManager;

public abstract class AbstractDataLayer
implements IDataLayer {
    protected IDBCluster dbCluster;
    protected IPrimaryCache primaryCache;
    protected ISecondCache secondCache;
    protected TransactionManager txManager;
    protected IEntityMetaManager entityMetaManager = DefaultEntityMetaManager.getInstance();

    @Override
    public IDBCluster getDBCluster() {
        return this.dbCluster;
    }

    @Override
    public void setDBCluster(IDBCluster dbCluster) {
        this.dbCluster = dbCluster;
    }

    @Override
    public IPrimaryCache getPrimaryCache() {
        return this.primaryCache;
    }

    @Override
    public void setPrimaryCache(IPrimaryCache primaryCache) {
        this.primaryCache = primaryCache;
    }

    @Override
    public ISecondCache getSecondCache() {
        return this.secondCache;
    }

    @Override
    public void setSecondCache(ISecondCache secondCache) {
        this.secondCache = secondCache;
    }

    @Override
    public void setTransactionManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    protected void fillParam(PreparedStatement ps, SQL sql) throws SQLException {
        Object val = null;
        for (int i = 1; i <= sql.getParams().size(); ++i) {
            val = sql.getParams().get(i - 1);
            if (val instanceof Boolean) {
                if (((Boolean)val).booleanValue()) {
                    ps.setString(i, "1");
                    continue;
                }
                ps.setString(i, "0");
                continue;
            }
            if (val instanceof Character || val instanceof String) {
                ps.setString(i, String.valueOf(val));
                continue;
            }
            if (val instanceof Byte) {
                ps.setByte(i, (Byte)val);
                continue;
            }
            if (val instanceof Short) {
                ps.setShort(i, (Short)val);
                continue;
            }
            if (val instanceof Integer) {
                ps.setInt(i, (Integer)val);
                continue;
            }
            if (val instanceof Long) {
                ps.setLong(i, (Long)val);
                continue;
            }
            if (val instanceof Float) {
                ps.setFloat(i, ((Float)val).floatValue());
                continue;
            }
            if (val instanceof Double) {
                ps.setDouble(i, (Double)val);
                continue;
            }
            if (val instanceof Date) {
                ps.setObject(i, (Date)val);
                continue;
            }
            if (val instanceof Timestamp) {
                ps.setObject(i, (Timestamp)val);
                continue;
            }
            throw new SQLException("\u65e0\u6cd5\u8bc6\u522b\u7684\u53c2\u6570\u7c7b\u578b" + val);
        }
    }

    protected boolean isCacheAvailable(Class<?> clazz) {
        return this.primaryCache != null && this.entityMetaManager.isCache(clazz);
    }

    protected boolean isSecondCacheAvailable(Class<?> clazz) {
        return this.secondCache != null && this.entityMetaManager.isCache(clazz);
    }

    protected boolean isCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.primaryCache != null && this.entityMetaManager.isCache(clazz) && useCache;
    }

    protected boolean isSecondCacheAvailable(Class<?> clazz, boolean useCache) {
        return this.secondCache != null && this.entityMetaManager.isCache(clazz) && useCache;
    }
}

