/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer;

import org.pinus4j.cache.IPrimaryCache;
import org.pinus4j.cache.ISecondCache;
import org.pinus4j.cluster.IDBCluster;
import org.pinus4j.datalayer.IDataLayerBuilder;
import org.pinus4j.datalayer.query.IGlobalQuery;
import org.pinus4j.datalayer.query.IShardingQuery;
import org.pinus4j.datalayer.query.jdbc.GlobalJdbcQueryImpl;
import org.pinus4j.datalayer.query.jdbc.ShardingJdbcQueryImpl;
import org.pinus4j.datalayer.update.IGlobalUpdate;
import org.pinus4j.datalayer.update.IShardingUpdate;
import org.pinus4j.datalayer.update.jdbc.GlobalJdbcUpdateImpl;
import org.pinus4j.datalayer.update.jdbc.ShardingJdbcUpdateImpl;
import org.pinus4j.generator.IIdGenerator;

public class JdbcDataLayerBuilder
implements IDataLayerBuilder {
    private IDBCluster dbCluster;
    private IPrimaryCache primaryCache;
    private ISecondCache secondCache;
    private static volatile JdbcDataLayerBuilder instance;

    private JdbcDataLayerBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataLayerBuilder valueOf(IDBCluster dbCluster) {
        if (instance != null) return instance;
        Class<JdbcDataLayerBuilder> clazz = JdbcDataLayerBuilder.class;
        synchronized (JdbcDataLayerBuilder.class) {
            if (instance != null) return instance;
            instance = new JdbcDataLayerBuilder();
            instance.setDBCluster(dbCluster);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void setDBCluster(IDBCluster dbCluster) {
        if (dbCluster == null) {
            throw new IllegalArgumentException("input param should not be null");
        }
        this.dbCluster = dbCluster;
    }

    @Override
    public IDataLayerBuilder setPrimaryCache(IPrimaryCache primaryCache) {
        if (this.primaryCache == null) {
            this.primaryCache = primaryCache;
        }
        return this;
    }

    @Override
    public IDataLayerBuilder setSecondCache(ISecondCache secondCache) {
        if (this.secondCache == null) {
            this.secondCache = secondCache;
        }
        return this;
    }

    @Override
    public IGlobalQuery buildGlobalQuery() {
        GlobalJdbcQueryImpl globalQuery = new GlobalJdbcQueryImpl();
        globalQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        globalQuery.setDBCluster(this.dbCluster);
        globalQuery.setPrimaryCache(this.primaryCache);
        globalQuery.setSecondCache(this.secondCache);
        return globalQuery;
    }

    @Override
    public IShardingQuery buildShardingQuery() {
        ShardingJdbcQueryImpl shardingQuery = new ShardingJdbcQueryImpl();
        shardingQuery.setTransactionManager(this.dbCluster.getTransactionManager());
        shardingQuery.setDBCluster(this.dbCluster);
        shardingQuery.setPrimaryCache(this.primaryCache);
        shardingQuery.setSecondCache(this.secondCache);
        return shardingQuery;
    }

    @Override
    public IGlobalUpdate buildGlobalUpdate(IIdGenerator idGenerator) {
        GlobalJdbcUpdateImpl globalUpdate = new GlobalJdbcUpdateImpl();
        globalUpdate.setTransactionManager(this.dbCluster.getTransactionManager());
        globalUpdate.setDBCluster(this.dbCluster);
        globalUpdate.setPrimaryCache(this.primaryCache);
        globalUpdate.setSecondCache(this.secondCache);
        return globalUpdate;
    }

    @Override
    public IShardingUpdate buildShardingUpdate(IIdGenerator idGenerator) {
        ShardingJdbcUpdateImpl shardingUpdate = new ShardingJdbcUpdateImpl();
        shardingUpdate.setTransactionManager(this.dbCluster.getTransactionManager());
        shardingUpdate.setDBCluster(this.dbCluster);
        shardingUpdate.setPrimaryCache(this.primaryCache);
        shardingUpdate.setSecondCache(this.secondCache);
        return shardingUpdate;
    }
}

