/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.datalayer.SQLParser;
import org.pinus4j.entity.DefaultEntityMetaManager;
import org.pinus4j.entity.IEntityMetaManager;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKName;
import org.pinus4j.entity.meta.PKValue;
import org.pinus4j.utils.BeansUtil;
import org.pinus4j.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(SQLBuilder.class);
    private static final Map<String, String> _selectCountCache = new ConcurrentHashMap<String, String>();
    private static IEntityMetaManager entityMetaManager = DefaultEntityMetaManager.getInstance();

    public static <T> SQL buildSelectPkByQuery(Class<T> clazz, int tableIndex, IQuery<T> query) {
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        PKName[] pkNames = entityMetaManager.getPkName(clazz);
        StringBuilder pkField = new StringBuilder();
        for (PKName pkName : pkNames) {
            pkField.append('`').append(pkName.getValue()).append('`').append(',');
        }
        pkField.deleteCharAt(pkField.length() - 1);
        SQL querySQL = ((DefaultQueryImpl)query).getWhereSql();
        StringBuilder sqlText = new StringBuilder("SELECT " + pkField.toString() + " FROM ");
        sqlText.append('`').append(tableName).append('`');
        String whereSql = querySQL.getSql();
        if (StringUtil.isNotBlank((String)whereSql)) {
            sqlText.append(whereSql);
        }
        SQL sql = SQL.valueOf(sqlText.toString(), querySQL.getParams());
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return sql;
    }

    public static <T> SQL buildSelectByQuery(Class<T> clazz, int tableIndex, IQuery<T> query) {
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        StringBuilder fields = new StringBuilder();
        if (((DefaultQueryImpl)query).hasQueryFields()) {
            for (String field : ((DefaultQueryImpl)query).getFields()) {
                fields.append('`').append(field).append('`').append(",");
            }
            fields.deleteCharAt(fields.length() - 1);
        } else {
            fields.append("*");
        }
        SQL querySQL = ((DefaultQueryImpl)query).getWhereSql();
        StringBuilder sqlText = new StringBuilder("SELECT ");
        sqlText.append(fields.toString()).append(" FROM ");
        sqlText.append('`').append(tableName).append('`');
        String whereSql = querySQL.getSql();
        if (StringUtil.isNotBlank((String)whereSql)) {
            sqlText.append(((DefaultQueryImpl)query).getWhereSql());
        }
        SQL sql = SQL.valueOf(sqlText.toString(), querySQL.getParams());
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return sql;
    }

    public static <T> SQL buildSelectCountByQuery(Class<T> clazz, int tableIndex, IQuery<T> query) {
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        StringBuilder sqlText = new StringBuilder("SELECT count(*) FROM ");
        sqlText.append('`').append(tableName).append('`');
        SQL querySQL = ((DefaultQueryImpl)query).getWhereSql();
        String whereSql = querySQL.getSql();
        if (StringUtil.isNotBlank((String)whereSql)) {
            sqlText.append(((DefaultQueryImpl)query).getWhereSql());
        }
        SQL sql = SQL.valueOf(sqlText.toString(), querySQL.getParams());
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return sql;
    }

    public static PreparedStatement buildSelectBySqlGlobal(Connection conn, SQL sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql.getSql());
        List<Object> params = sql.getParams();
        if (params != null) {
            for (int i = 1; i <= params.size(); ++i) {
                ps.setObject(i, params.get(i - 1));
            }
        }
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return ps;
    }

    public static PreparedStatement buildSelectBySql(Connection conn, SQL sql, int tableIndex) throws SQLException {
        String s = SQLParser.addTableIndex(sql.getSql(), tableIndex);
        PreparedStatement ps = conn.prepareStatement(s);
        List<Object> params = sql.getParams();
        if (params != null) {
            for (int i = 1; i <= params.size(); ++i) {
                ps.setObject(i, params.get(i - 1));
            }
        }
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return ps;
    }

    public static String buildSelectCountGlobalSql(Class<?> clazz) {
        String tableName = entityMetaManager.getTableName(clazz, -1);
        StringBuilder SQL2 = new StringBuilder("SELECT count(*) ").append("FROM ");
        SQL2.append('`').append(tableName).append('`');
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static String buildSelectCountSql(Class<?> clazz, int tableIndex) {
        String sql = _selectCountCache.get(clazz.getName() + tableIndex);
        if (sql != null) {
            SQLBuilder.debugSQL(sql);
            return sql;
        }
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        StringBuilder SQL2 = new StringBuilder("SELECT count(*) ").append("FROM ");
        SQL2.append('`').append(tableName).append('`');
        _selectCountCache.put(clazz.getName() + tableIndex, SQL2.toString());
        SQLBuilder.debugSQL(SQL2.toString());
        return SQL2.toString();
    }

    public static SQL buildSelectByPks(EntityPK[] pks, List<DefaultQueryImpl.OrderBy> orders, Class<?> clazz, int tableIndex) throws SQLException {
        Field[] fields = BeansUtil.getFields(clazz, (boolean)true);
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        StringBuilder whereSql = new StringBuilder();
        StringBuilder orderSql = new StringBuilder();
        StringBuilder findInSet = new StringBuilder();
        ArrayList paramList = Lists.newArrayList();
        if (entityMetaManager.isUnionKey(clazz)) {
            for (EntityPK pk : pks) {
                whereSql.append("(");
                for (int i = 0; i < pk.getPkNames().length; ++i) {
                    whereSql.append('`').append(pk.getPkNames()[i].getValue()).append('`');
                    whereSql.append("=").append('?');
                    whereSql.append(" and ");
                    paramList.add(SQLBuilder.formatValue(pk.getPkValues()[i].getValue()));
                }
                whereSql.delete(whereSql.length() - 5, whereSql.length());
                whereSql.append(")");
                whereSql.append(" or ");
            }
            whereSql.delete(whereSql.length() - 4, whereSql.length());
        } else {
            String pkName = entityMetaManager.getNotUnionPkName(clazz).getValue();
            findInSet.append("find_in_set(").append(pkName).append(",'");
            whereSql.append(pkName).append(" in (");
            for (EntityPK pk : pks) {
                whereSql.append("?,");
                findInSet.append(pk.getPkValues()[0].getValue()).append(',');
                paramList.add(SQLBuilder.formatValue(pk.getPkValues()[0].getValue()));
            }
            whereSql.deleteCharAt(whereSql.length() - 1);
            whereSql.append(")");
            findInSet.deleteCharAt(findInSet.length() - 1);
            findInSet.append("')");
        }
        if (orders != null && !orders.isEmpty()) {
            orderSql.append(" order by ");
            for (DefaultQueryImpl.OrderBy orderBy : orders) {
                orderSql.append('`').append(orderBy.getField()).append('`');
                orderSql.append(" ");
                orderSql.append(orderBy.getOrder().getValue());
                orderSql.append(",");
            }
            orderSql.deleteCharAt(orderSql.length() - 1);
        } else if (StringUtil.isNotBlank((String)findInSet.toString())) {
            orderSql.append(" order by ");
            orderSql.append((CharSequence)findInSet);
        }
        StringBuilder sqlText = new StringBuilder("SELECT ");
        for (Field field : fields) {
            sqlText.append('`').append(BeansUtil.getFieldName((Field)field)).append('`').append(",");
        }
        sqlText.deleteCharAt(sqlText.length() - 1);
        sqlText.append(" FROM ").append('`').append(tableName).append('`');
        sqlText.append(" WHERE ").append(whereSql.toString());
        if (StringUtil.isNotBlank((String)orderSql.toString())) {
            sqlText.append((CharSequence)orderSql);
        }
        SQL sql = SQL.valueOf(sqlText.toString(), paramList);
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return sql;
    }

    public static SQL buildDeleteByPks(Class<?> clazz, int tableIndex, List<EntityPK> pks) throws SQLException {
        String tableName = entityMetaManager.getTableName(clazz, tableIndex);
        StringBuilder whereSql = new StringBuilder();
        ArrayList paramList = Lists.newArrayList();
        for (EntityPK pk : pks) {
            whereSql.append("(");
            for (int i = 0; i < pk.getPkNames().length; ++i) {
                whereSql.append('`').append(pk.getPkNames()[i].getValue()).append('`');
                whereSql.append("=").append('?');
                whereSql.append(" and ");
                paramList.add(SQLBuilder.formatValue(pk.getPkValues()[i].getValue()));
            }
            whereSql.delete(whereSql.length() - 5, whereSql.length());
            whereSql.append(")");
            whereSql.append(" or ");
        }
        whereSql.delete(whereSql.length() - 4, whereSql.length());
        StringBuilder sqlText = new StringBuilder("DELETE FROM ").append('`').append(tableName).append('`');
        sqlText.append(" WHERE ").append(whereSql.toString());
        SQL sql = SQL.valueOf(sqlText.toString(), paramList);
        SQLBuilder.debugSQL(sql.getSql());
        SQLBuilder.debugSQLParam(sql.getParams());
        return sql;
    }

    public static SQL getUpdate(Object entity, int tableIndex) throws SQLException {
        String tableName = entityMetaManager.getTableName(entity, tableIndex);
        Map entityProperty = null;
        try {
            entityProperty = BeansUtil.describe((Object)entity, (boolean)true);
        }
        catch (Exception e) {
            throw new SQLException("\u89e3\u6790\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25", e);
        }
        EntityPK entityPk = entityMetaManager.getEntityPK(entity);
        StringBuilder pkWhereSql = new StringBuilder();
        ArrayList whereParam = Lists.newArrayList();
        for (int i = 0; i < entityPk.getPkNames().length; ++i) {
            pkWhereSql.append('`').append(entityPk.getPkNames()[i].getValue()).append('`');
            pkWhereSql.append("=").append('?');
            pkWhereSql.append(" and ");
            whereParam.add(SQLBuilder.formatValue(entityPk.getPkValues()[i].getValue()));
        }
        pkWhereSql.delete(pkWhereSql.length() - 5, pkWhereSql.length());
        ArrayList paramList = Lists.newArrayList();
        Set propertyEntrySet = entityProperty.entrySet();
        StringBuilder sqlText = new StringBuilder("UPDATE `" + tableName + "` SET ");
        Object value = null;
        for (Map.Entry propertyEntry : propertyEntrySet) {
            value = propertyEntry.getValue();
            sqlText.append('`').append((String)propertyEntry.getKey()).append('`');
            sqlText.append("=").append("?");
            sqlText.append(",");
            paramList.add(SQLBuilder.formatValue(value));
        }
        sqlText.deleteCharAt(sqlText.length() - 1);
        sqlText.append(" WHERE ").append(pkWhereSql.toString());
        paramList.addAll(whereParam);
        SQL sql = SQL.valueOf(sqlText.toString(), paramList);
        SQLBuilder.debugSQL(sqlText.toString());
        SQLBuilder.debugSQLParam(paramList);
        return sql;
    }

    public static SQL getInsert(Object entity, int tableIndex) throws SQLException {
        String tableName = entityMetaManager.getTableName(entity, tableIndex);
        Map entityProperty = null;
        try {
            entityProperty = BeansUtil.describe((Object)entity, (boolean)true);
        }
        catch (Exception e) {
            throw new SQLException("\u89e3\u6790\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25", e);
        }
        Set propertyEntrySet = entityProperty.entrySet();
        ArrayList paramList = Lists.newArrayList();
        StringBuilder sqlText = new StringBuilder("INSERT INTO `" + tableName + "` (");
        StringBuilder var = new StringBuilder();
        for (Map.Entry propertyEntry : propertyEntrySet) {
            sqlText.append('`').append((String)propertyEntry.getKey()).append('`').append(",");
            var.append('?').append(',');
            paramList.add(SQLBuilder.formatValue(propertyEntry.getValue()));
        }
        sqlText.deleteCharAt(sqlText.length() - 1);
        sqlText.append(") VALUES (");
        sqlText.append(var.deleteCharAt(var.length() - 1).toString());
        sqlText.append(")");
        SQL sql = SQL.valueOf(sqlText.toString(), paramList);
        SQLBuilder.debugSQL(sqlText.toString());
        SQLBuilder.debugSQLParam(paramList);
        return sql;
    }

    public static List<Map<String, Object>> createResultObject(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rsmd = rs.getMetaData();
        LinkedHashMap one = null;
        while (rs.next()) {
            try {
                one = Maps.newLinkedHashMap();
                String fieldName = null;
                Object value = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    value = rs.getObject(i);
                    one.put(fieldName, value);
                }
                list.add(one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return list;
    }

    public static <T> List<T> createResultObject(Class<T> clazz, ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        Object one = null;
        while (rs.next()) {
            try {
                one = clazz.newInstance();
                String fieldName = null;
                Field f = null;
                Object value = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    f = BeansUtil.getField(clazz, (String)fieldName);
                    if (f == null) continue;
                    value = SQLBuilder._getRsValue(rs, f, i);
                    BeansUtil.setProperty(one, (String)fieldName, (Object)value);
                }
                list.add(one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return list;
    }

    public static <T> Map<EntityPK, T> createResultObjectAsMap(Class<T> clazz, ResultSet rs) throws SQLException {
        LinkedHashMap map = Maps.newLinkedHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        Object one = null;
        String fieldName = null;
        PKName[] pkNames = entityMetaManager.getPkName(clazz);
        PKValue[] pkValues = null;
        Field f = null;
        Object value = null;
        while (rs.next()) {
            try {
                int i;
                one = clazz.newInstance();
                for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                    fieldName = rsmd.getColumnName(i);
                    f = BeansUtil.getField(clazz, (String)fieldName);
                    if (f == null) continue;
                    value = SQLBuilder._getRsValue(rs, f, i);
                    BeansUtil.setProperty(one, (String)fieldName, (Object)value);
                }
                pkValues = new PKValue[pkNames.length];
                for (i = 0; i < pkNames.length; ++i) {
                    pkValues[i] = PKValue.valueOf((Object)rs.getObject(pkNames[i].getValue()));
                }
                map.put(EntityPK.valueOf((PKName[])pkNames, (PKValue[])pkValues), one);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return map;
    }

    private static Object _getRsValue(ResultSet rs, Field f, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (value != null) {
            if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                value = rs.getString(i).equals("1");
            } else if (f.getType() == Byte.TYPE || f.getType() == Byte.class) {
                value = rs.getByte(i);
            } else if (f.getType() == Character.TYPE || f.getType() == Character.class) {
                String s = rs.getString(i);
                value = s.length() > 0 ? Character.valueOf(rs.getString(i).charAt(0)) : new Character('\u0000');
            } else if (f.getType() == Short.TYPE || f.getType() == Short.class) {
                value = rs.getShort(i);
            } else if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                value = rs.getLong(i);
            } else if ((f.getType() == Integer.TYPE || f.getType() == Integer.class) && value instanceof Boolean) {
                value = (Boolean)value != false ? new Integer(1) : new Integer(0);
            }
        }
        return value;
    }

    public static Object formatValue(Object value) {
        Object format = null;
        format = value instanceof Character && ((Character)value).charValue() == '\'' ? "'\\" + (Character)value + "'" : value;
        return format;
    }

    public static void debugSQL(String sql) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(sql);
        }
    }

    public static void debugSQLParam(List<Object> params) {
        if (LOG.isDebugEnabled() && params != null && !params.isEmpty()) {
            StringBuilder paramText = new StringBuilder();
            for (Object param : params) {
                paramText.append(param).append(',');
            }
            paramText.deleteCharAt(paramText.length() - 1);
            LOG.debug(paramText.toString());
        }
    }
}

