/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class SQLParser {
    public static List<String> parseTableName(String sql) {
        Statement st;
        try {
            st = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        Select selectStatement = (Select)st;
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(selectStatement);
        return tableNames;
    }

    public static String addTableIndex(String sql, int tableIndex) {
        List<String> tableNames = SQLParser.parseTableName(sql);
        Pattern p = null;
        Matcher m = null;
        for (String tableName : tableNames) {
            p = Pattern.compile(tableName);
            m = p.matcher(sql);
            int i = 0;
            while (m.find()) {
                int start = m.start() + i;
                int end = m.end() + i;
                char cStart = sql.charAt(start - 1);
                char cEnd = sql.charAt(end);
                if (cStart != ' ' && cStart != '=' || cEnd != ' ' && cEnd != ',' && cEnd != '.') continue;
                sql = sql.substring(0, start) + tableName + tableIndex + sql.substring(end);
                ++i;
            }
        }
        return sql;
    }
}

