/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.iterator;

import java.sql.SQLException;
import java.util.List;
import org.pinus4j.api.query.impl.Condition;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.api.query.impl.Order;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.iterator.AbstractRecordIterator;
import org.pinus4j.entity.DefaultEntityMetaManager;
import org.pinus4j.entity.IEntityMetaManager;
import org.pinus4j.exceptions.DBOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingRecordIterator<E>
extends AbstractRecordIterator<E> {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingRecordIterator.class);
    private ShardingDBResource dbResource;
    private IEntityMetaManager entityMetaManager = DefaultEntityMetaManager.getInstance();

    public ShardingRecordIterator(ShardingDBResource dbResource, Class<E> clazz) {
        super(clazz);
        this.dbResource = dbResource;
        this.maxId = this.getMaxId();
    }

    @Override
    public long getMaxId() {
        List one;
        long maxId = 0L;
        DefaultQueryImpl query = new DefaultQueryImpl();
        query.limit(1).orderBy(this.pkName, Order.DESC, this.clazz);
        try {
            one = this.selectByQuery((IDBResource)this.dbResource, query, this.clazz);
        }
        catch (SQLException e1) {
            throw new DBOperationException((Exception)e1);
        }
        if (!one.isEmpty()) {
            Object e = one.get(0);
            maxId = this.entityMetaManager.getNotUnionPkValue(e).getValueAsLong();
        }
        LOG.info("clazz " + this.clazz + " DB " + this.dbResource + " maxId=" + maxId);
        return maxId;
    }

    @Override
    public long getCount() {
        try {
            return this.selectCountByQuery(this.query, (IDBResource)this.dbResource, this.clazz).longValue();
        }
        catch (SQLException e) {
            throw new DBOperationException((Exception)e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordQ.isEmpty()) {
            Object query = ((DefaultQueryImpl)this.query).clone();
            long high = this.latestId + (long)this.step;
            query.and(Condition.gte(this.pkName, this.latestId, this.clazz)).and(Condition.lt(this.pkName, high, this.clazz));
            try {
                List recrods = this.selectByQuery((IDBResource)this.dbResource, query, this.clazz);
                this.latestId = high;
                while (recrods.isEmpty() && this.latestId < this.maxId) {
                    query = ((DefaultQueryImpl)this.query).clone();
                    high = this.latestId + (long)this.step;
                    query.and(Condition.gte(this.pkName, this.latestId, this.clazz)).and(Condition.lt(this.pkName, high, this.clazz));
                    recrods = this.selectByQuery((IDBResource)this.dbResource, query, this.clazz);
                    this.latestId = high;
                }
                this.recordQ.addAll(recrods);
            }
            catch (SQLException e) {
                throw new DBOperationException((Exception)e);
            }
        }
        return !this.recordQ.isEmpty();
    }
}

