/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.query.jdbc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.AbstractDataLayer;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.SlowQueryLogger;
import org.pinus4j.datalayer.query.IDataQuery;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.utils.JdbcUtil;

public abstract class AbstractJdbcQuery
extends AbstractDataLayer
implements IDataQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number _selectCount(IDBResource dbResource, Class<?> clazz) throws SQLException {
        Long l;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            String sql = null;
            sql = dbResource.isGlobal() ? SQLBuilder.buildSelectCountGlobalSql(clazz) : SQLBuilder.buildSelectCountSql(clazz, ((ShardingDBResource)dbResource).getTableIndex());
            ps = conn.prepareStatement(sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps, rs);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps, (ResultSet)rs);
        return l;
    }

    protected Number selectCountWithCache(IDBResource dbResource, Class<?> clazz, boolean useCache) throws SQLException {
        long count;
        String clusterName = dbResource.getClusterName();
        String tableName = this.entityMetaManager.getTableName(clazz);
        if (this.isCacheAvailable(clazz, useCache)) {
            count = 0L;
            count = dbResource.isGlobal() ? this.primaryCache.getCountGlobal(clusterName, tableName) : this.primaryCache.getCount((ShardingDBResource)dbResource);
            if (count > 0L) {
                return count;
            }
        }
        count = 0L;
        count = this._selectCount(dbResource, clazz).longValue();
        if (this.isCacheAvailable(clazz, useCache) && count > 0L) {
            if (dbResource.isGlobal()) {
                this.primaryCache.setCountGlobal(clusterName, tableName, count);
            } else {
                this.primaryCache.setCount((ShardingDBResource)dbResource, count);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Number selectCountByQuery(IQuery<T> query, IDBResource dbResource, Class<T> clazz) throws SQLException {
        long count = -1L;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            SQL sql = null;
            sql = dbResource.isGlobal() ? SQLBuilder.buildSelectCountByQuery(clazz, -1, query) : SQLBuilder.buildSelectCountByQuery(clazz, ((ShardingDBResource)dbResource).getTableIndex(), query);
            ps = conn.prepareStatement(sql.getSql());
            this.fillParam(ps, sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 2000L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps, rs);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps, (ResultSet)rs);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<EntityPK, T> _selectByPks(IDBResource dbResource, Class<T> clazz, EntityPK[] pks, List<DefaultQueryImpl.OrderBy> order) throws SQLException {
        Map<Object, Object> result = Maps.newLinkedHashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            SQL sql = null;
            sql = dbResource.isGlobal() ? SQLBuilder.buildSelectByPks(pks, order, clazz, -1) : SQLBuilder.buildSelectByPks(pks, order, clazz, ((ShardingDBResource)dbResource).getTableIndex());
            ps = conn.prepareStatement(sql.getSql());
            this.fillParam(ps, sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 10L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.createResultObjectAsMap(clazz, rs);
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps, rs);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps, (ResultSet)rs);
        return result;
    }

    protected <T> Map<EntityPK, T> selectByPksWithCache(IDBResource dbResource, Class<T> clazz, EntityPK[] pks, List<DefaultQueryImpl.OrderBy> order, boolean useCache) throws SQLException {
        Map<Object, Object> result = Maps.newLinkedHashMap();
        if (pks == null || pks.length == 0) {
            return result;
        }
        if (!this.isCacheAvailable(clazz, useCache)) {
            return this._selectByPks(dbResource, clazz, pks, order);
        }
        String tableName = this.entityMetaManager.getTableName(clazz);
        String clusterName = dbResource.getClusterName();
        Map hitResult = null;
        hitResult = dbResource.isGlobal() ? this.primaryCache.getGlobal(clusterName, tableName, pks) : this.primaryCache.get((ShardingDBResource)dbResource, pks);
        if (hitResult == null || hitResult.isEmpty()) {
            result = this._selectByPks(dbResource, clazz, pks, order);
            if (dbResource.isGlobal()) {
                this.primaryCache.putGlobal(clusterName, tableName, (Map)result);
            } else {
                this.primaryCache.put((ShardingDBResource)dbResource, (Map)result);
            }
            return result;
        }
        if (hitResult.size() == pks.length) {
            return hitResult;
        }
        try {
            ArrayList noHitPkList = Lists.newArrayList();
            for (EntityPK pk : pks) {
                if (hitResult.get(pk) != null) continue;
                noHitPkList.add(pk);
            }
            EntityPK[] noHitPks = noHitPkList.toArray(new EntityPK[noHitPkList.size()]);
            Map<EntityPK, T> noHitMap = this._selectByPks(dbResource, clazz, noHitPks, order);
            if (!noHitMap.isEmpty()) {
                if (dbResource.isGlobal()) {
                    this.primaryCache.putGlobal(clusterName, tableName, noHitMap);
                } else {
                    this.primaryCache.put((ShardingDBResource)dbResource, noHitMap);
                }
            }
            for (EntityPK pk : pks) {
                if (hitResult.get(pk) != null) {
                    result.put(pk, hitResult.get(pk));
                    continue;
                }
                result.put(pk, noHitMap.get(pk));
            }
        }
        catch (Exception e) {
            result = this._selectByPks(dbResource, clazz, pks, order);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> selectBySql(IDBResource dbResource, SQL sql) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            ps = dbResource.isGlobal() ? SQLBuilder.buildSelectBySqlGlobal(conn, sql) : SQLBuilder.buildSelectBySql(conn, sql, ((ShardingDBResource)dbResource).getTableIndex());
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.createResultObject(rs);
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps, rs);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps, (ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> selectByQuery(IDBResource dbResource, IQuery<T> query, Class<T> clazz) throws SQLException {
        List<T> result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conn = dbResource.getConnection();
            SQL sql = null;
            sql = dbResource.isGlobal() ? SQLBuilder.buildSelectByQuery(clazz, -1, query) : SQLBuilder.buildSelectByQuery(clazz, ((ShardingDBResource)dbResource).getTableIndex(), query);
            ps = conn.prepareStatement(sql.getSql());
            this.fillParam(ps, sql);
            long begin = System.currentTimeMillis();
            rs = ps.executeQuery();
            long constTime = System.currentTimeMillis() - begin;
            if (constTime > 50L) {
                SlowQueryLogger.write(conn, sql, constTime);
            }
            result = SQLBuilder.createResultObject(clazz, rs);
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps, rs);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps, (ResultSet)rs);
        return result;
    }

    /*
     * Exception decompiling
     */
    protected <T> EntityPK[] selectPksByQuery(IDBResource dbResource, IQuery<T> query, Class<T> clazz) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

