/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.query.jdbc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.cluster.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.query.IGlobalQuery;
import org.pinus4j.datalayer.query.jdbc.AbstractJdbcQuery;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.BeansUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcQueryImpl
extends AbstractJdbcQuery
implements IGlobalQuery {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcQueryImpl.class);

    @Override
    public Number getCount(Class<?> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        String clusterName = this.entityMetaManager.getClusterName(clazz);
        String tableName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            long count;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isGlobalSlaveExist(clusterName)) {
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
            } else {
                dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((count = this.selectCountWithCache(dbResource, clazz, useCache).longValue()) == 0L && isFromSlave) {
                dbResource.close();
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                count = this.selectCountWithCache(dbResource, clazz, useCache).longValue();
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> Number getCountByQuery(IQuery<T> query, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        String clusterName = this.entityMetaManager.getClusterName(clazz);
        String tableName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            long count;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isGlobalSlaveExist(clusterName)) {
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
            } else {
                dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((count = this.selectCountByQuery(query, dbResource, clazz).longValue()) == 0L && isFromSlave) {
                dbResource.close();
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                count = this.selectCountByQuery(query, dbResource, clazz).longValue();
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findByPk(EntityPK pk, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        List<T> result = this.findByPkList(Lists.newArrayList((Object[])new EntityPK[]{pk}), clazz, null, useCache, masterSlave);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> findByPkList(List<EntityPK> pkList, Class<T> clazz, List<DefaultQueryImpl.OrderBy> order, boolean useCache, EnumDBMasterSlave masterSlave) {
        ArrayList result = Lists.newArrayList();
        String clusterName = this.entityMetaManager.getClusterName(clazz);
        String tableName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            EntityPK[] entityPks;
            Map<EntityPK, T> data;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isGlobalSlaveExist(clusterName)) {
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
            } else {
                dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((data = this.selectByPksWithCache(dbResource, clazz, entityPks = pkList.toArray(new EntityPK[pkList.size()]), order, useCache)).isEmpty() && isFromSlave) {
                dbResource.close();
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                data = this.selectByPksWithCache(dbResource, clazz, entityPks, order, useCache);
            }
            result.addAll(data.values());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findByQuery(IQuery<T> query, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        String sCacheKey;
        List sCacheData;
        List<Object> result = Lists.newArrayList();
        if (query == null) {
            query = new DefaultQueryImpl();
        }
        String clusterName = this.entityMetaManager.getClusterName(clazz);
        String tableName = this.entityMetaManager.getTableName(clazz);
        if (this.isSecondCacheAvailable(clazz, useCache) && (sCacheData = this.secondCache.getGlobal(sCacheKey = ((DefaultQueryImpl)query).getWhereSql().getSecondCacheKey(), clusterName, tableName)) != null) {
            return sCacheData;
        }
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isGlobalSlaveExist(clusterName)) {
                dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
            } else {
                dbResource = this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if (this.isCacheAvailable(clazz, useCache)) {
                EntityPK[] entityPks = this.selectPksByQuery(dbResource, query, clazz);
                Map<EntityPK, T> datas = this.selectByPksWithCache(dbResource, clazz, entityPks, ((DefaultQueryImpl)query).getOrderList(), useCache);
                if ((datas == null || datas.isEmpty()) && isFromSlave) {
                    dbResource.close();
                    dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
                    if (tx != null) {
                        tx.enlistResource((XAResource)dbResource);
                    }
                    datas = this.selectByPksWithCache(dbResource, clazz, entityPks, ((DefaultQueryImpl)query).getOrderList(), useCache);
                }
                result.addAll(datas.values());
            } else {
                result = this.selectByQuery(dbResource, query, clazz);
                if ((result == null || result.isEmpty()) && isFromSlave) {
                    dbResource.close();
                    dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, tableName);
                    if (tx != null) {
                        tx.enlistResource((XAResource)dbResource);
                    }
                    result = this.selectByQuery(dbResource, query, clazz);
                }
            }
            if (this.isSecondCacheAvailable(clazz, useCache)) {
                String sCacheKey2 = ((DefaultQueryImpl)query).getWhereSql().getSecondCacheKey();
                this.secondCache.putGlobal(sCacheKey2, clusterName, tableName, (List)result);
            }
            ArrayList<Object> filteResult = new ArrayList<Object>(result.size());
            if (((DefaultQueryImpl)query).hasQueryFields()) {
                for (Object obj : result) {
                    filteResult.add(BeansUtil.cloneWithGivenField((Object)obj, (String[])((DefaultQueryImpl)query).getFields()));
                }
                result = filteResult;
            }
            List<Object> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public List<Map<String, Object>> findBySql(SQL sql, String clusterName, EnumDBMasterSlave masterSlave) {
        Object cur;
        Object next = null;
        for (String tableName : sql.getTableNames()) {
            cur = null;
            try {
                cur = EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isGlobalSlaveExist(clusterName) ? this.dbCluster.getMasterGlobalDBResource(clusterName, tableName) : this.dbCluster.getSlaveGlobalDBResource(clusterName, tableName, masterSlave);
            }
            catch (DBClusterException e) {
                throw new DBOperationException((Exception)((Object)e));
            }
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)next);
            }
            List<Map<String, Object>> result = this.selectBySql((IDBResource)next, sql);
            cur = result;
            return cur;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && next != null) {
                next.close();
            }
        }
    }
}

