/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.query.jdbc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.api.SQL;
import org.pinus4j.api.query.IQuery;
import org.pinus4j.api.query.impl.DefaultQueryImpl;
import org.pinus4j.api.query.impl.Order;
import org.pinus4j.cluster.beans.IShardingKey;
import org.pinus4j.cluster.enums.EnumDBMasterSlave;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.query.IShardingQuery;
import org.pinus4j.datalayer.query.jdbc.AbstractJdbcQuery;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.pinus4j.utils.BeansUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcQueryImpl
extends AbstractJdbcQuery
implements IShardingQuery {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcQueryImpl.class);

    @Override
    public Number getCount(Class<?> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        List dbResources = null;
        try {
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            String clusterName = this.entityMetaManager.getClusterName(clazz);
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(clusterName)) {
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
            } else {
                dbResources = this.dbCluster.getAllSlaveShardingDBResource(clazz, masterSlave);
                isFromSlave = true;
            }
            long count = 0L;
            for (IDBResource dbResource : dbResources) {
                if (tx != null) {
                    tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                }
                count += this.selectCountWithCache(dbResource, clazz, useCache).longValue();
            }
            if (count == 0L && isFromSlave) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                for (IDBResource dbResource : dbResources) {
                    if (tx != null) {
                        tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                    }
                    count += this.selectCountWithCache((IDBResource)((ShardingDBResource)dbResource), clazz, useCache).longValue();
                }
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResources != null) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
            }
        }
    }

    @Override
    public Number getCount(IShardingKey<?> shardingKey, Class<?> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            long count;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
                dbResource = this._getDbFromMaster(clazz, shardingKey);
            } else {
                dbResource = this._getDbFromSlave(clazz, shardingKey, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((count = this.selectCountWithCache((IDBResource)dbResource, clazz, useCache).longValue()) == 0L && isFromSlave) {
                dbResource.close();
                dbResource = this._getDbFromMaster(clazz, shardingKey);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                this.selectCountWithCache((IDBResource)dbResource, clazz, useCache);
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> Number getCountByQuery(IQuery<T> query, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        List dbResources = null;
        try {
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            String clusterName = this.entityMetaManager.getClusterName(clazz);
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(clusterName)) {
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
            } else {
                dbResources = this.dbCluster.getAllSlaveShardingDBResource(clazz, masterSlave);
                isFromSlave = true;
            }
            long count = 0L;
            for (IDBResource dbResource : dbResources) {
                if (tx != null) {
                    tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                }
                count += this.selectCountByQuery(query, (IDBResource)((ShardingDBResource)dbResource), clazz).longValue();
            }
            if (count == 0L && isFromSlave) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                for (IDBResource dbResource : dbResources) {
                    if (tx != null) {
                        tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                    }
                    count += this.selectCountByQuery(query, (IDBResource)((ShardingDBResource)dbResource), clazz).longValue();
                }
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResources != null) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
            }
        }
    }

    @Override
    public <T> Number getCountByQuery(IQuery<T> query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            long count;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
                dbResource = this._getDbFromMaster(clazz, shardingKey);
            } else {
                dbResource = this._getDbFromSlave(clazz, shardingKey, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((count = this.selectCountByQuery(query, (IDBResource)dbResource, clazz).longValue()) == 0L && isFromSlave) {
                dbResource.close();
                dbResource = this._getDbFromMaster(clazz, shardingKey);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                count = this.selectCountByQuery(query, (IDBResource)dbResource, clazz).longValue();
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> T findByPk(EntityPK pk, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            Map<EntityPK, T> data;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
                dbResource = this._getDbFromMaster(clazz, shardingKey);
            } else {
                dbResource = this._getDbFromSlave(clazz, shardingKey, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if (((data = this.selectByPksWithCache((IDBResource)dbResource, clazz, new EntityPK[]{pk}, null, useCache)) == null || data.isEmpty()) && isFromSlave) {
                dbResource.close();
                dbResource = this._getDbFromMaster(clazz, shardingKey);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                data = this.selectByPksWithCache((IDBResource)dbResource, clazz, new EntityPK[]{pk}, null, useCache);
            }
            T t = data.get(pk);
            return t;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findByPkList(List<EntityPK> pkList, Class<T> clazz, List<DefaultQueryImpl.OrderBy> order, boolean useCache, EnumDBMasterSlave masterSlave) {
        ArrayList result = Lists.newArrayList();
        Transaction tx = null;
        List dbResources = null;
        try {
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            String clusterName = this.entityMetaManager.getClusterName(clazz);
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(clusterName)) {
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
            } else {
                dbResources = this.dbCluster.getAllSlaveShardingDBResource(clazz, masterSlave);
                isFromSlave = true;
            }
            EntityPK[] entityPkList = pkList.toArray(new EntityPK[pkList.size()]);
            LinkedHashMap data = Maps.newLinkedHashMap();
            for (IDBResource dbResource : dbResources) {
                if (tx != null) {
                    tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                }
                data.putAll(this.selectByPksWithCache((IDBResource)((ShardingDBResource)dbResource), clazz, entityPkList, order, useCache));
            }
            if (data.isEmpty() && isFromSlave) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                for (IDBResource dbResource : dbResources) {
                    if (tx != null) {
                        tx.enlistResource((XAResource)((ShardingDBResource)dbResource));
                    }
                    data.putAll(this.selectByPksWithCache((IDBResource)((ShardingDBResource)dbResource), clazz, entityPkList, order, useCache));
                }
            }
            result.addAll(data.values());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResources != null) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
            }
        }
    }

    @Override
    public <T> List<T> findByPkList(List<EntityPK> pkList, IShardingKey<?> shardingKey, Class<T> clazz, List<DefaultQueryImpl.OrderBy> order, boolean useCache, EnumDBMasterSlave masterSlave) {
        ArrayList result = Lists.newArrayList();
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            EntityPK[] entityPkList;
            Map<EntityPK, T> data;
            tx = this.txManager.getTransaction();
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
                dbResource = this._getDbFromMaster(clazz, shardingKey);
            } else {
                dbResource = this._getDbFromSlave(clazz, shardingKey, masterSlave);
                isFromSlave = true;
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            if ((data = this.selectByPksWithCache((IDBResource)dbResource, clazz, entityPkList = pkList.toArray(new EntityPK[pkList.size()]), order, useCache)).isEmpty() && isFromSlave) {
                dbResource.close();
                dbResource = this._getDbFromMaster(clazz, shardingKey);
                if (tx != null) {
                    tx.enlistResource((XAResource)dbResource);
                }
                data = this.selectByPksWithCache((IDBResource)dbResource, clazz, entityPkList, order, useCache);
            }
            result.addAll(data.values());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public <T> List<T> findByQuery(IQuery<T> query, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        boolean isFromSlave = false;
        List dbResources = null;
        DefaultQueryImpl internalQuery = (DefaultQueryImpl)query;
        try {
            String clusterName = this.entityMetaManager.getClusterName(clazz);
            if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(clusterName)) {
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
            } else {
                dbResources = this.dbCluster.getAllSlaveShardingDBResource(clazz, masterSlave);
                isFromSlave = true;
            }
            int start = internalQuery.getStart();
            int limit = internalQuery.getLimit();
            int sum = start + limit;
            if (start >= 0 && limit > 0) {
                internalQuery.limit(0, sum);
            }
            final List<DefaultQueryImpl.OrderBy> orderList = internalQuery.getOrderList();
            boolean isOrderQuery = false;
            if (orderList != null && !orderList.isEmpty()) {
                isOrderQuery = true;
            }
            ArrayList mergeResult = Lists.newArrayList();
            for (IDBResource dbResource : dbResources) {
                if (isOrderQuery) {
                    mergeResult.addAll(this._findByQuery(internalQuery, dbResource, clazz, useCache, masterSlave));
                    continue;
                }
                mergeResult.addAll(this._findByQuery(internalQuery, dbResource, clazz, useCache, masterSlave));
                if (mergeResult.size() < sum) continue;
                break;
            }
            if (mergeResult.isEmpty() && isFromSlave) {
                for (IDBResource dbResource : dbResources) {
                    dbResource.close();
                }
                dbResources = this.dbCluster.getAllMasterShardingDBResource(clazz);
                for (IDBResource dbResource : dbResources) {
                    if (isOrderQuery) {
                        mergeResult.addAll(this._findByQuery(internalQuery, dbResource, clazz, useCache, masterSlave));
                        continue;
                    }
                    mergeResult.addAll(this._findByQuery(internalQuery, dbResource, clazz, useCache, masterSlave));
                    if (mergeResult.size() < sum) continue;
                    break;
                }
            }
            if (orderList != null && !orderList.isEmpty()) {
                Collections.sort(mergeResult, new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        Object v1 = null;
                        Object v2 = null;
                        Class<?> fieldType = null;
                        int compareVal = 0;
                        for (DefaultQueryImpl.OrderBy order : orderList) {
                            v1 = BeansUtil.getProperty(o1, (String)order.getField());
                            v2 = BeansUtil.getProperty(o2, (String)order.getField());
                            fieldType = order.getFieldType();
                            if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                                compareVal = ((Boolean)v1).compareTo((Boolean)v2);
                            } else if (fieldType == Character.class || fieldType == Character.TYPE) {
                                compareVal = ((Character)v1).compareTo((Character)v2);
                            } else if (fieldType == Byte.class || fieldType == Byte.TYPE) {
                                compareVal = ((Byte)v1).compareTo((Byte)v2);
                            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                                compareVal = ((Short)v1).compareTo((Short)v2);
                            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                                compareVal = ((Integer)v1).compareTo((Integer)v2);
                            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                                compareVal = ((Long)v1).compareTo((Long)v2);
                            } else if (fieldType == Float.class || fieldType == Float.TYPE) {
                                compareVal = ((Float)v1).compareTo((Float)v2);
                            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                                compareVal = ((Double)v1).compareTo((Double)v2);
                            } else if (fieldType == String.class) {
                                compareVal = ((String)v1).compareTo((String)v2);
                            } else if (fieldType == Date.class) {
                                compareVal = ((Date)v1).compareTo((Date)v2);
                            } else if (fieldType == Timestamp.class) {
                                compareVal = ((Timestamp)v1).compareTo((Timestamp)v2);
                            } else {
                                throw new RuntimeException("\u65e0\u6cd5\u6392\u5e8f\u7684\u7c7b\u578b" + order);
                            }
                            if (order.getOrder() == Order.DESC) {
                                compareVal *= -1;
                            }
                            if (compareVal == 0) continue;
                            break;
                        }
                        return compareVal;
                    }
                });
            }
            List result = null;
            if (start > -1 && limit > -1) {
                int fromIndex = start;
                int endIndex = sum > mergeResult.size() ? mergeResult.size() : sum;
                result = mergeResult.subList(fromIndex, endIndex);
            } else {
                result = limit > -1 ? mergeResult.subList(0, limit - 1) : mergeResult;
            }
            return result;
        }
        catch (Exception e) {
            throw new DBOperationException(e);
        }
    }

    @Override
    public <T> List<T> findByQuery(IQuery<T> query, IShardingKey<?> shardingKey, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        boolean isFromSlave = false;
        ShardingDBResource dbResource = null;
        if (EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
            dbResource = this._getDbFromMaster(clazz, shardingKey);
        } else {
            dbResource = this._getDbFromSlave(clazz, shardingKey, masterSlave);
            isFromSlave = true;
        }
        List<T> data = this._findByQuery(query, (IDBResource)dbResource, clazz, useCache, masterSlave);
        if (data.isEmpty() && isFromSlave) {
            dbResource.close();
            dbResource = this._getDbFromMaster(clazz, shardingKey);
            data = this._findByQuery(query, (IDBResource)dbResource, clazz, useCache, masterSlave);
        }
        return data;
    }

    private <T> List<T> _findByQuery(IQuery<T> query, IDBResource dbResource, Class<T> clazz, boolean useCache, EnumDBMasterSlave masterSlave) {
        List<Object> result = Lists.newArrayList();
        Transaction tx = null;
        try {
            String sCacheKey;
            List sCacheData;
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            Map<EntityPK, T> data = null;
            if (this.isSecondCacheAvailable(clazz, useCache) && (sCacheData = this.secondCache.get(sCacheKey = ((DefaultQueryImpl)query).getWhereSql().getSecondCacheKey(), (ShardingDBResource)dbResource)) != null && !sCacheData.isEmpty()) {
                result.addAll(sCacheData);
            }
            if (result == null || result.isEmpty()) {
                if (this.isCacheAvailable(clazz, useCache)) {
                    EntityPK[] entityPks = this.selectPksByQuery((IDBResource)((ShardingDBResource)dbResource), query, clazz);
                    data = this.selectByPksWithCache(dbResource, clazz, entityPks, ((DefaultQueryImpl)query).getOrderList(), useCache);
                    result.addAll(data.values());
                } else {
                    result = this.selectByQuery((IDBResource)((ShardingDBResource)dbResource), query, clazz);
                }
                if (this.isSecondCacheAvailable(clazz, useCache)) {
                    sCacheKey = ((DefaultQueryImpl)query).getWhereSql().getSecondCacheKey();
                    this.secondCache.put(sCacheKey, (ShardingDBResource)dbResource, result);
                }
            }
            ArrayList<Object> filteResult = new ArrayList<Object>(data.size());
            if (((DefaultQueryImpl)query).hasQueryFields()) {
                for (Object obj : result) {
                    try {
                        filteResult.add(BeansUtil.cloneWithGivenField((Object)obj, (String[])((DefaultQueryImpl)query).getFields()));
                    }
                    catch (Exception e) {
                        throw new DBOperationException(e);
                    }
                }
                result = filteResult;
            }
            List<Object> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public List<Map<String, Object>> findBySql(SQL sql, EnumDBMasterSlave masterSlave) {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public List<Map<String, Object>> findBySql(SQL sql, IShardingKey<?> shardingKey, EnumDBMasterSlave masterSlave) {
        Transaction tx = null;
        ShardingDBResource dbResource = this._getDbBySQL(sql, shardingKey, masterSlave);
        try {
            List<Map<String, Object>> result;
            tx = this.txManager.getTransaction();
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            }
            boolean isFromSlave = false;
            if (EnumDBMasterSlave.MASTER != masterSlave && this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName())) {
                isFromSlave = true;
            }
            if ((result = this.selectBySql((IDBResource)dbResource, sql)).isEmpty() && isFromSlave) {
                dbResource = this._getDbBySQL(sql, shardingKey, EnumDBMasterSlave.MASTER);
                result = this.selectBySql((IDBResource)dbResource, sql);
            }
            List<Map<String, Object>> list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    throw new DBOperationException(e1);
                }
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private ShardingDBResource _getDbBySQL(SQL sql, IShardingKey<?> shardingKey, EnumDBMasterSlave masterSlave) {
        ShardingDBResource next = null;
        for (String tableName : sql.getTableNames()) {
            ShardingDBResource cur = null;
            cur = EnumDBMasterSlave.MASTER == masterSlave || !this.dbCluster.isShardingSlaveExist(shardingKey.getClusterName()) ? this._getDbFromMaster(tableName, shardingKey) : this._getDbFromSlave(tableName, shardingKey, masterSlave);
            if (next != null && cur != next) {
                throw new DBOperationException("the tables in sql maybe not at the same database");
            }
            next = cur;
        }
        return next;
    }

    private ShardingDBResource _getDbFromMaster(Class<?> clazz, IShardingKey<?> shardingKey) {
        String tableName = this.entityMetaManager.getTableName(clazz);
        return this._getDbFromMaster(tableName, shardingKey);
    }

    private ShardingDBResource _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException((Exception)((Object)e));
        }
        return shardingDBResource;
    }

    private ShardingDBResource _getDbFromSlave(Class<?> clazz, IShardingKey<?> shardingKey, EnumDBMasterSlave masterSlave) {
        String tableName = this.entityMetaManager.getTableName(clazz);
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromSlave(tableName, shardingKey, masterSlave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException((Exception)((Object)e));
        }
        return shardingDBResource;
    }

    private ShardingDBResource _getDbFromSlave(String tableName, IShardingKey<?> shardingKey, EnumDBMasterSlave slave) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromSlave(tableName, shardingKey, slave);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException((Exception)((Object)e));
        }
        return shardingDBResource;
    }
}

