/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.update.jdbc;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.pinus4j.api.SQL;
import org.pinus4j.datalayer.AbstractDataLayer;
import org.pinus4j.datalayer.SQLBuilder;
import org.pinus4j.datalayer.update.IDataUpdate;
import org.pinus4j.entity.meta.DBTablePK;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKValue;
import org.pinus4j.utils.BeansUtil;
import org.pinus4j.utils.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcUpdate
extends AbstractDataLayer
implements IDataUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcUpdate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PKValue> _saveBatchWithAutoGeneratedKeys(Connection conn, List<? extends Object> entities, int tableIndex) throws SQLException {
        ArrayList pks = Lists.newArrayList();
        PreparedStatement ps = null;
        SQL sql = null;
        Class<?> clazz = null;
        try {
            for (Object object : entities) {
                sql = SQLBuilder.getInsert(object, tableIndex);
                if (ps == null) {
                    ps = conn.prepareStatement(sql.getSql(), 1);
                }
                this.fillParam(ps, sql);
                ps.executeUpdate();
                clazz = object.getClass();
                if (this.entityMetaManager.isUnionKey(clazz)) continue;
                DBTablePK dbTablePK = this.entityMetaManager.getNotUnionPrimaryKey(clazz);
                if (dbTablePK.isAutoIncrement()) {
                    ResultSet rs = ps.getGeneratedKeys();
                    Field f = BeansUtil.getField(clazz, (String)dbTablePK.getField());
                    Object incrPK = null;
                    if (!rs.next()) continue;
                    incrPK = rs.getObject(1);
                    if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                        BeansUtil.setProperty((Object)object, (String)dbTablePK.getField(), (Object)((Long)incrPK).intValue());
                        pks.add(PKValue.valueOf((Object)((Long)incrPK).intValue()));
                        continue;
                    }
                    BeansUtil.setProperty((Object)object, (String)dbTablePK.getField(), (Object)incrPK);
                    pks.add(PKValue.valueOf((Object)incrPK));
                    continue;
                }
                pks.add(PKValue.valueOf((Object)BeansUtil.getProperty((Object)object, (String)dbTablePK.getField())));
            }
        }
        finally {
            JdbcUtil.close(ps);
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected int _saveBatchWithoutAutoGeneratedKeys(Connection conn, List<? extends Object> entities, int tableIndex) throws SQLException {
        int insertCount = 0;
        Statement ps = null;
        try {
            void var8_10;
            SQL sql = null;
            for (Object object : entities) {
                sql = SQLBuilder.getInsert(object, tableIndex);
                if (ps == null) {
                    ps = conn.prepareStatement(sql.getSql());
                }
                this.fillParam((PreparedStatement)ps, sql);
                ps.addBatch();
            }
            int[] insertCountArray = ps.executeBatch();
            boolean bl = false;
            while (var8_10 < insertCountArray.length) {
                insertCount += insertCountArray[var8_10];
                ++var8_10;
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps);
        return insertCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _removeByPks(Connection conn, List<EntityPK> pks, Class<?> clazz, int tableIndex) throws SQLException {
        int removeCount = 0;
        PreparedStatement ps = null;
        try {
            SQL sql = SQLBuilder.buildDeleteByPks(clazz, tableIndex, pks);
            ps = conn.prepareStatement(sql.getSql());
            this.fillParam(ps, sql);
            removeCount = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps);
        return removeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected int _updateBatch(Connection conn, List<? extends Object> entities, int tableIndex) throws SQLException {
        int updateCount = 0;
        Statement ps = null;
        try {
            void var8_10;
            SQL sql = null;
            for (Object object : entities) {
                sql = SQLBuilder.getUpdate(object, tableIndex);
                if (ps == null) {
                    ps = conn.prepareStatement(sql.getSql());
                }
                this.fillParam((PreparedStatement)ps, sql);
                ps.addBatch();
            }
            int[] updateCountArray = ps.executeBatch();
            boolean bl = false;
            while (var8_10 < updateCountArray.length) {
                updateCount += updateCountArray[var8_10];
                ++var8_10;
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(ps);
            throw throwable;
        }
        JdbcUtil.close((PreparedStatement)ps);
        return updateCount;
    }
}

