/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.update.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.datalayer.update.IGlobalUpdate;
import org.pinus4j.datalayer.update.jdbc.AbstractJdbcUpdate;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKValue;
import org.pinus4j.exceptions.DBOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IGlobalUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalJdbcUpdateImpl.class);

    @Override
    public PKValue save(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>(1);
        entities.add(entity);
        PKValue[] pkValues = this.saveBatch(entities, clusterName, true);
        if (pkValues.length > 0) {
            return pkValues[0];
        }
        return null;
    }

    @Override
    public PKValue[] saveBatch(List<? extends Object> entities, String clusterName, boolean autoGeneratedKeys) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = this.entityMetaManager.getTableName(clazz);
        List<Object> pks = new ArrayList();
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, this.entityMetaManager.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            int insertCount = 0;
            if (autoGeneratedKeys) {
                pks = this._saveBatchWithAutoGeneratedKeys(conn, entities, -1);
                insertCount = pks.size();
            } else {
                insertCount = this._saveBatchWithoutAutoGeneratedKeys(conn, entities, -1);
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz) && insertCount > 0) {
                this.primaryCache.incrCountGlobal(clusterName, tableName, insertCount);
            }
            if (this.isSecondCacheAvailable(clazz) && insertCount > 0) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e1) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e1);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return pks.toArray(new PKValue[pks.size()]);
    }

    @Override
    public void update(Object entity, String clusterName) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.updateBatch(entities, clusterName);
    }

    @Override
    public void updateBatch(List<? extends Object> entities, String clusterName) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, this.entityMetaManager.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            int updateCount = this._updateBatch(conn, entities, -1);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz) && updateCount > 0) {
                ArrayList<EntityPK> pks = new ArrayList<EntityPK>(entities.size());
                for (Object object : entities) {
                    pks.add(this.entityMetaManager.getEntityPK(object));
                }
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
            }
            if (this.isSecondCacheAvailable(clazz) && updateCount > 0) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public void removeByPk(EntityPK pk, Class<?> clazz, String clusterName) {
        ArrayList<EntityPK> pks = new ArrayList<EntityPK>(1);
        pks.add(pk);
        this.removeByPks(pks, clazz, clusterName);
    }

    @Override
    public void removeByPks(List<EntityPK> pks, Class<?> clazz, String clusterName) {
        Transaction tx = null;
        IDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this.dbCluster.getMasterGlobalDBResource(clusterName, this.entityMetaManager.getTableName(clazz));
            Connection conn = dbResource.getConnection();
            int removeCount = this._removeByPks(conn, pks, clazz, -1);
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            String tableName = this.entityMetaManager.getTableName(clazz);
            if (this.isCacheAvailable(clazz) && removeCount > 0) {
                this.primaryCache.removeGlobal(clusterName, tableName, pks);
                this.primaryCache.decrCountGlobal(clusterName, tableName, removeCount);
            }
            if (this.isSecondCacheAvailable(clazz) && removeCount > 0) {
                this.secondCache.removeGlobal(clusterName, tableName);
            }
        }
        catch (Exception e) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }
}

