/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.datalayer.update.jdbc;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.pinus4j.cluster.beans.IShardingKey;
import org.pinus4j.cluster.resources.ShardingDBResource;
import org.pinus4j.datalayer.update.IShardingUpdate;
import org.pinus4j.datalayer.update.jdbc.AbstractJdbcUpdate;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKValue;
import org.pinus4j.exceptions.DBClusterException;
import org.pinus4j.exceptions.DBOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingJdbcUpdateImpl
extends AbstractJdbcUpdate
implements IShardingUpdate {
    public static final Logger LOG = LoggerFactory.getLogger(ShardingJdbcUpdateImpl.class);

    @Override
    public PKValue save(Object entity, IShardingKey<?> shardingKey) {
        PKValue[] pkValues = this.saveBatch(Lists.newArrayList((Object[])new Object[]{entity}), shardingKey, true);
        if (pkValues != null && pkValues.length > 0) {
            return pkValues[0];
        }
        return null;
    }

    @Override
    public PKValue[] saveBatch(List<? extends Object> entities, IShardingKey<?> shardingKey, boolean autoGeneratedKeys) {
        Class<?> clazz = entities.get(0).getClass();
        String tableName = this.entityMetaManager.getTableName(clazz);
        List<Object> pks = Lists.newArrayList();
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(tableName, shardingKey);
            Connection conn = dbResource.getConnection();
            int insertCount = 0;
            if (autoGeneratedKeys) {
                pks = this._saveBatchWithAutoGeneratedKeys(conn, entities, dbResource.getTableIndex());
                insertCount = pks.size();
            } else {
                insertCount = this._saveBatchWithoutAutoGeneratedKeys(conn, entities, dbResource.getTableIndex());
            }
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz) && insertCount > 0) {
                this.primaryCache.incrCount(dbResource, (long)insertCount);
            }
            if (this.isSecondCacheAvailable(clazz) && insertCount > 0) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
        return pks.toArray(new PKValue[pks.size()]);
    }

    @Override
    public void update(Object entity, IShardingKey<?> shardingKey) {
        ArrayList<Object> entities = new ArrayList<Object>();
        entities.add(entity);
        this.updateBatch(entities, shardingKey);
    }

    @Override
    public void updateBatch(List<? extends Object> entities, IShardingKey<?> shardingKey) {
        Class<?> clazz = entities.get(0).getClass();
        String talbeName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(talbeName, shardingKey);
            Connection conn = dbResource.getConnection();
            int updateCount = this._updateBatch(conn, entities, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz) && updateCount > 0) {
                ArrayList entityPkList = Lists.newArrayList();
                for (Object object : entities) {
                    entityPkList.add(this.entityMetaManager.getEntityPK(object));
                }
                this.primaryCache.remove(dbResource, (List)entityPkList);
            }
            if (this.isSecondCacheAvailable(clazz) && updateCount > 0) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    @Override
    public void removeByPk(EntityPK pk, IShardingKey<?> shardingKey, Class<?> clazz) {
        ArrayList pks = Lists.newArrayListWithCapacity((int)1);
        pks.add(pk);
        this.removeByPks(pks, shardingKey, clazz);
    }

    @Override
    public void removeByPks(List<EntityPK> pks, IShardingKey<?> shardingKey, Class<?> clazz) {
        String talbeName = this.entityMetaManager.getTableName(clazz);
        Transaction tx = null;
        ShardingDBResource dbResource = null;
        try {
            tx = this.txManager.getTransaction();
            dbResource = this._getDbFromMaster(talbeName, shardingKey);
            Connection conn = dbResource.getConnection();
            this._removeByPks(conn, pks, clazz, dbResource.getTableIndex());
            if (tx != null) {
                tx.enlistResource((XAResource)dbResource);
            } else {
                dbResource.commit();
            }
            if (this.isCacheAvailable(clazz)) {
                this.primaryCache.remove(dbResource, pks);
                this.primaryCache.decrCount(dbResource, (long)pks.size());
            }
            if (this.isSecondCacheAvailable(clazz)) {
                this.secondCache.remove(dbResource);
            }
        }
        catch (Exception e) {
            if (tx == null && dbResource != null) {
                dbResource.rollback();
            }
            throw new DBOperationException(e);
        }
        finally {
            if (tx == null && dbResource != null) {
                dbResource.close();
            }
        }
    }

    private ShardingDBResource _getDbFromMaster(String tableName, IShardingKey<?> shardingKey) {
        ShardingDBResource shardingDBResource = null;
        try {
            shardingDBResource = (ShardingDBResource)this.dbCluster.selectDBResourceFromMaster(tableName, shardingKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[" + shardingDBResource + "]");
            }
        }
        catch (DBClusterException e) {
            throw new DBOperationException((Exception)((Object)e));
        }
        return shardingDBResource;
    }
}

