/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.task;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.pinus4j.cluster.resources.IDBResource;
import org.pinus4j.exceptions.TaskException;
import org.pinus4j.task.ITask;
import org.pinus4j.utils.ThreadPool;

public class TaskFuture {
    private long total;
    private CountDownLatch cdl;
    private AtomicLong count = new AtomicLong(0L);
    private ThreadPool threadPool;
    private ITask<?> task;
    private List<IDBResource> dbResources = new ArrayList<IDBResource>();

    public TaskFuture(long total, ThreadPool threadPool, ITask<?> task) {
        this.total = total;
        this.cdl = new CountDownLatch((int)total);
        this.threadPool = threadPool;
        this.task = task;
    }

    public String getProgress() {
        double val = new Long(this.count.get()).doubleValue() / new Long(this.total).doubleValue();
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(val);
    }

    public boolean isDone() {
        return this.count.get() == this.total;
    }

    public void await() throws InterruptedException {
        try {
            this.cdl.await();
        }
        catch (Exception e) {
            throw new TaskException(e);
        }
    }

    public void down(int count) {
        for (int i = 0; i < count; ++i) {
            this.cdl.countDown();
        }
        if (this.isDone()) {
            try {
                this.task.finish();
            }
            catch (Exception e) {
                throw new TaskException(e);
            }
            finally {
                this.threadPool.shutdown();
                for (IDBResource dbResource : this.dbResources) {
                    dbResource.close();
                }
            }
        }
    }

    public void incrCount(int count) {
        if (this.count.get() < this.total) {
            this.count.addAndGet(count);
        }
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count.get();
    }

    public void addDBResource(IDBResource dbResource) {
        this.dbResources.add(dbResource);
    }

    public void addDBResource(List<IDBResource> dbResources) {
        this.dbResources.addAll(dbResources);
    }

    public String toString() {
        return "TaskFuture [total=" + this.total + ", cdl=" + this.cdl + ", count=" + this.count + "]";
    }
}

