/*
 * Decompiled with CFR 0.152.
 */
package org.pinus4j.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.pinus4j.entity.meta.EntityPK;
import org.pinus4j.entity.meta.PKValue;

public class PKUtil {
    public static List<EntityPK> parseEntityPKList(List<PKValue> pkValueList) {
        ArrayList entityPkList = Lists.newArrayList();
        PKValue[] pkValues = null;
        for (PKValue pkValue : pkValueList) {
            pkValues = new PKValue[]{pkValue};
            entityPkList.add(EntityPK.valueOf(null, (PKValue[])pkValues));
        }
        return entityPkList;
    }

    public static List<? extends Number> parseNumberValueList(List<PKValue> pkValueList) {
        if (pkValueList == null) {
            return null;
        }
        ArrayList pkNumberList = Lists.newArrayListWithCapacity((int)pkValueList.size());
        for (PKValue pkValue : pkValueList) {
            pkNumberList.add(pkValue.getValueAsNumber());
        }
        return pkNumberList;
    }

    public static List<PKValue> parsePKValueList(List<? extends Number> pkNumberList) {
        if (pkNumberList == null) {
            return null;
        }
        ArrayList pkValueList = Lists.newArrayListWithCapacity((int)pkNumberList.size());
        for (Number number : pkNumberList) {
            pkValueList.add(PKValue.valueOf((Object)number));
        }
        return pkValueList;
    }

    public static PKValue[] parsePKValueArray(Number[] pkNumbers) {
        if (pkNumbers == null) {
            return null;
        }
        PKValue[] pkValues = new PKValue[pkNumbers.length];
        for (int i = 0; i < pkNumbers.length; ++i) {
            pkValues[i] = PKValue.valueOf((Object)pkNumbers[i]);
        }
        return pkValues;
    }

    public static Number[] parseNumberArray(PKValue[] pkValues) {
        if (pkValues == null) {
            return null;
        }
        Number[] pkNumber = new Number[pkValues.length];
        for (int i = 0; i < pkValues.length; ++i) {
            pkNumber[i] = pkValues[i].getValueAsNumber();
        }
        return pkNumber;
    }
}

