/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage.amazon_s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.infra.storage.amazon_s3.S3Bucket;

public class S3
implements Storage<S3Bucket, S3ObjectSummary> {
    public static final String S3_PATH_SEPARATOR = "/";
    private final AmazonS3 impl;

    public S3(AWSCredentials credentials) {
        this.impl = S3.connect(credentials);
    }

    public S3() {
        this(null);
    }

    public S3Bucket getBucket(String bucketName) {
        return new S3Bucket(this.impl, bucketName);
    }

    public String getProtocol() {
        return "s3";
    }

    public static S3Bucket bucket(AWSCredentials credentials, String name) {
        return new S3Bucket(S3.connect(credentials), name);
    }

    private static AmazonS3 connect(AWSCredentials credentials) {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.US_EAST_1);
        if (credentials != null) {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials));
        }
        return (AmazonS3)builder.build();
    }
}

