/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.pipecraft.infra.concurrent.CheckedFuture;

public abstract class AbstractCheckedFuture<V, E extends Exception>
implements CheckedFuture<V, E> {
    private final ListenableFuture<V> future;

    public AbstractCheckedFuture(ListenableFuture<V> future) {
        this.future = future;
    }

    @Override
    public V checkedGet() throws InterruptedException, E {
        try {
            return (V)this.future.get();
        }
        catch (ExecutionException e) {
            this.handleExecutionException(e);
            throw new IllegalStateException("Unreachable");
        }
    }

    @Override
    public V checkedGet(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, E {
        try {
            return (V)this.future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            this.handleExecutionException(e);
            throw new IllegalStateException("Unreachable");
        }
    }

    protected abstract E map(Exception var1);

    public void addListener(Runnable listener, Executor executor) {
        this.future.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.future.get();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.future.get(timeout, unit);
    }

    private void handleExecutionException(ExecutionException e) throws E {
        Throwable err = e.getCause();
        if (err instanceof Error) {
            throw (Error)err;
        }
        throw this.map((Exception)err);
    }
}

