/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface FailableBiConsumer<A, B, E extends Exception> {
    public void accept(A var1, B var2) throws E;

    default public FailableBiConsumer<A, B, E> andThen(FailableBiConsumer<? super A, ? super B, ? extends E> after) {
        Objects.requireNonNull(after);
        return (a, b) -> {
            this.accept(a, b);
            after.accept(a, b);
        };
    }

    public static <X, Y, E extends Exception> FailableBiConsumer<X, Y, E> fromBiConsumer(final BiConsumer<X, Y> biConsumer) {
        return new FailableBiConsumer<X, Y, E>(){

            @Override
            public void accept(X a, Y b) throws Exception {
                biConsumer.accept(a, b);
            }
        };
    }
}

