/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class FutureCompletionHandler<T>
implements Runnable {
    private final Future<? extends T> future;
    private final Consumer<? super T> successListener;
    private final Consumer<Throwable> errorListener;

    protected FutureCompletionHandler(Consumer<? super T> successListener, Consumer<Throwable> errorListener, Future<? extends T> future) {
        this.successListener = successListener;
        this.errorListener = errorListener;
        this.future = future;
    }

    @Override
    public void run() {
        T res;
        try {
            res = this.future.get();
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                e = e.getCause();
            }
            this.errorListener.accept(e);
            return;
        }
        this.successListener.accept(res);
    }

    public static <T> void listenTo(ListenableFuture<T> future, Consumer<? super T> successListener, Consumer<Throwable> errorListener) {
        FutureCompletionHandler.listenTo(future, successListener, errorListener, MoreExecutors.directExecutor());
    }

    public static <T> void listenTo(ListenableFuture<T> future, Consumer<? super T> successListener, Consumer<Throwable> errorListener, Executor ex) {
        future.addListener(new FutureCompletionHandler<T>(successListener, errorListener, future), ex);
    }

    public static <T> void listenToSuccess(ListenableFuture<T> future, Consumer<? super T> successListener) {
        FutureCompletionHandler.listenToSuccess(future, successListener, MoreExecutors.directExecutor());
    }

    public static <T> void listenToSuccess(ListenableFuture<T> future, Consumer<? super T> successListener, Executor ex) {
        future.addListener(new FutureCompletionHandler<T>(successListener, e -> {}, future), ex);
    }

    public static void listenToError(ListenableFuture<?> future, Consumer<Throwable> errorListener) {
        FutureCompletionHandler.listenToError(future, errorListener, MoreExecutors.directExecutor());
    }

    public static void listenToError(ListenableFuture<?> future, Consumer<Throwable> errorListener, Executor ex) {
        future.addListener(new FutureCompletionHandler<Object>(r -> {}, errorListener, (Future<Object>)future), ex);
    }
}

