/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LockFreeBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private static final int YIELD_MAX = 64;
    private static final int SLEEP_INITIAL_MS = 1;
    private static final int SLEEP_MAX_MS = 1024;
    private static final double SLEEP_FACTOR = 2.0;
    private final ConcurrentLinkedQueue<E> queue;
    private final AtomicInteger size = new AtomicInteger();
    private final int approxSizeLimit;

    public LockFreeBlockingQueue(int approxSizeLimit) {
        this.queue = new ConcurrentLinkedQueue();
        this.approxSizeLimit = approxSizeLimit;
    }

    @Override
    public boolean offer(E e) {
        if (this.size.get() >= this.approxSizeLimit) {
            return false;
        }
        this.queue.add(e);
        this.size.incrementAndGet();
        return true;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        long startMs = System.currentTimeMillis();
        long maxDurationMs = unit.toMillis(timeout);
        if (this.offer(e)) {
            return true;
        }
        for (int i = 0; i < 64; ++i) {
            Thread.yield();
            if (this.offer(e)) {
                return true;
            }
            LockFreeBlockingQueue.checkInterruption();
        }
        long sleepMs = 1L;
        while (true) {
            LockFreeBlockingQueue.sleep(sleepMs, startMs, maxDurationMs);
            if (this.offer(e)) {
                return true;
            }
            if (System.currentTimeMillis() - startMs > maxDurationMs) {
                return false;
            }
            LockFreeBlockingQueue.checkInterruption();
            sleepMs = Math.min(1024L, (long)((double)sleepMs * 2.0));
        }
    }

    @Override
    public E poll() {
        E res = this.queue.poll();
        if (res != null) {
            this.size.decrementAndGet();
        }
        return res;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long startMs = System.currentTimeMillis();
        long maxDurationMs = unit.toMillis(timeout);
        E value = this.poll();
        if (value != null) {
            return value;
        }
        for (int i = 0; i < 64; ++i) {
            Thread.yield();
            value = this.poll();
            if (value != null) {
                return value;
            }
            LockFreeBlockingQueue.checkInterruption();
        }
        long sleepMs = 1L;
        while (true) {
            LockFreeBlockingQueue.sleep(sleepMs, startMs, maxDurationMs);
            value = this.poll();
            if (value != null) {
                return value;
            }
            if (System.currentTimeMillis() - startMs > maxDurationMs) {
                return null;
            }
            LockFreeBlockingQueue.checkInterruption();
            sleepMs = Math.min(1024L, (long)((double)sleepMs * 2.0));
        }
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.offer(e)) {
            return;
        }
        for (int i = 0; i < 64; ++i) {
            Thread.yield();
            if (this.offer(e)) {
                return;
            }
            LockFreeBlockingQueue.checkInterruption();
        }
        long sleepMs = 1L;
        while (true) {
            Thread.sleep(sleepMs);
            if (this.offer(e)) {
                return;
            }
            LockFreeBlockingQueue.checkInterruption();
            sleepMs = Math.min(1024L, (long)((double)sleepMs * 2.0));
        }
    }

    @Override
    public E take() throws InterruptedException {
        E value = this.poll();
        if (value != null) {
            return value;
        }
        for (int i = 0; i < 64; ++i) {
            Thread.yield();
            value = this.poll();
            if (value != null) {
                return value;
            }
            LockFreeBlockingQueue.checkInterruption();
        }
        long sleepMs = 1L;
        while (true) {
            Thread.sleep(sleepMs);
            value = this.poll();
            if (value != null) {
                return value;
            }
            LockFreeBlockingQueue.checkInterruption();
            sleepMs = Math.min(1024L, (long)((double)sleepMs * 2.0));
        }
    }

    @Override
    public int remainingCapacity() {
        return this.approxSizeLimit - this.size.get();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int count;
        for (count = 0; count < maxElements && (e = this.poll()) != null; ++count) {
            c.add(e);
        }
        return count;
    }

    private static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static void sleep(long sleepMs, long startMs, long maxDurationMs) throws InterruptedException {
        Thread.sleep(Math.min(sleepMs, Math.max(0L, startMs + maxDurationMs - System.currentTimeMillis())));
    }
}

