/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.pipecraft.infra.concurrent.FailableInterruptibleConsumer;

public class ParallelTaskProcessor {
    public static <T, E extends Exception> void runFailable(ExecutorService ex, Collection<T> items, FailableInterruptibleConsumer<? super T, E> processor) throws E, InterruptedException {
        ParallelTaskProcessor.internalRun(ex, items, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void runFailable(Collection<T> items, int parallelism, FailableInterruptibleConsumer<? super T, E> processor) throws E, InterruptedException {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat(ParallelTaskProcessor.class.getSimpleName() + "-%d").build();
        ExecutorService ex = Executors.newFixedThreadPool(parallelism, tf);
        try {
            ParallelTaskProcessor.internalRun(ex, items, processor);
        }
        finally {
            ex.shutdownNow();
        }
    }

    public static <T> void run(ExecutorService ex, Collection<T> items, Consumer<? super T> processor) throws InterruptedException {
        ParallelTaskProcessor.internalRun(ex, items, FailableInterruptibleConsumer.fromConsumer(processor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void run(Collection<T> items, int parallelism, Consumer<? super T> processor) throws RuntimeException, InterruptedException {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat(ParallelTaskProcessor.class.getSimpleName() + "-%d").build();
        ExecutorService ex = Executors.newFixedThreadPool(parallelism, tf);
        try {
            ParallelTaskProcessor.internalRun(ex, items, FailableInterruptibleConsumer.fromConsumer(processor));
        }
        finally {
            ex.shutdownNow();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static <T, E extends Exception> void internalRun(ExecutorService ex, Collection<T> items, FailableInterruptibleConsumer<? super T, E> processor) throws E, InterruptedException {
        block23: {
            ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(ex);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(items.size());
            for (T item : items) {
                ItemsProcessorTask<? super T> task = new ItemsProcessorTask<T>(item, processor);
                futures.add(ecs.submit(task));
            }
            try {
                for (int i = 0; i < items.size(); ++i) {
                    ecs.take().get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof InterruptedException) {
                    throw (InterruptedException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw (Exception)cause;
            }
            finally {
                for (Future f : futures) {
                    if (f.isDone()) continue;
                    f.cancel(true);
                }
                for (Future f : futures) {
                    try {
                        f.get();
                    }
                    catch (CancellationException | ExecutionException e2) {
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!Thread.interrupted()) break block23;
                throw new InterruptedException();
            }
        }
    }

    private static class ItemsProcessorTask<T>
    implements Callable<Void> {
        private final T item;
        private final FailableInterruptibleConsumer<? super T, ?> consumer;

        public ItemsProcessorTask(T item, FailableInterruptibleConsumer<? super T, ?> consumer) {
            this.item = item;
            this.consumer = consumer;
        }

        @Override
        public Void call() throws Exception {
            this.consumer.accept(this.item);
            return null;
        }
    }
}

