/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.io;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum Compression {
    NONE(null, 0),
    GZIP(".gz", -1),
    ZSTD(".zst", 3),
    LZ4(".lz4", 0);

    private final String fileExtension;
    private final int defaultCompressionLevel;

    private Compression(String fileExtension, int defaultCompressionLevel) {
        this.fileExtension = fileExtension;
        this.defaultCompressionLevel = defaultCompressionLevel;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public int getDefaultCompressionLevel() {
        return this.defaultCompressionLevel;
    }

    public static Compression detect(String filename) {
        return Arrays.stream(Compression.values()).filter(compression -> StringUtils.endsWith((CharSequence)filename, (CharSequence)compression.fileExtension)).findAny().orElse(NONE);
    }

    public static Compression detect(File file) {
        return Compression.detect(file.getName());
    }

    public String withExtension(String filename) {
        return filename + (this.fileExtension == null ? "" : this.fileExtension);
    }
}

