/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.math;

import java.util.List;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public final class ArithmeticUtils {
    private static final XXHash64 XXHASH = XXHashFactory.safeInstance().hash64();
    private static final long XXHASH_SEED = 1969L;
    private static final int PRECISION = 1000000;

    private ArithmeticUtils() {
    }

    public static double getUnionProbability(List<Double> probabilities) {
        int size = probabilities.size();
        int powerSetSize = 1 << size;
        double odd = 0.0;
        double even = 0.0;
        for (int i = 1; i < powerSetSize; ++i) {
            double mul = 1.0;
            for (int j = 0; j < size; ++j) {
                if ((i & 1 << j) == 0) continue;
                mul *= probabilities.get(j).doubleValue();
            }
            if ((Integer.bitCount(i) & 1) == 1) {
                odd += mul;
                continue;
            }
            even += mul;
        }
        return odd - even;
    }

    public static boolean getConsistentBooleanByProbability(Object object, float probability) {
        long hash = (long)object.hashCode() & 0xFFFFFFFFL;
        long score = hash % 1000000L;
        return (float)score < probability * 1000000.0f;
    }

    public static int getShardByHash(Object obj, int n) {
        long hash = (long)obj.hashCode() & 0xFFFFFFFFL;
        return (int)(hash % (long)n);
    }

    public static int getShardByStrongHash(byte[] objBytes, int n) {
        long hash = XXHASH.hash(objBytes, 0, objBytes.length, 1969L);
        return (int)((hash &= Long.MAX_VALUE) % (long)n);
    }
}

